/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class JamesServerWithRetryConnectionTest {
    private static final long WAITING_TIME = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
    private static final DockerOpenSearchExtension dockerOpenSearch = new DockerOpenSearchExtension();
    private static final CassandraExtension dockerCassandra = new CassandraExtension();
    @RegisterExtension
    static JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)dockerOpenSearch).extension((GuiceModuleTestExtension)dockerCassandra).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).disableAutoStart().build();
    private SocketChannel socketChannel;
    private ExecutorService executorService;

    JamesServerWithRetryConnectionTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        this.executorService = Executors.newFixedThreadPool(1, (ThreadFactory)threadFactory);
        this.socketChannel = SocketChannel.open();
    }

    @AfterEach
    void after() throws IOException {
        this.socketChannel.close();
        this.executorService.shutdownNow();
    }

    @Test
    void serverShouldStartAtDefault(GuiceJamesServer server) throws Exception {
        this.assertThatServerStartCorrectly(server);
    }

    @Test
    void serverShouldRetryToConnectToCassandraWhenStartService(GuiceJamesServer server) throws Exception {
        dockerCassandra.getCassandra().pause();
        this.waitToStartContainer(WAITING_TIME, dockerCassandra.getCassandra()::unpause);
        this.assertThatServerStartCorrectly(server);
    }

    @Test
    void serverShouldRetryToConnectToOpenSearchWhenStartService(GuiceJamesServer server) throws Exception {
        dockerOpenSearch.getDockerOS().pause();
        this.waitToStartContainer(WAITING_TIME, () -> ((DockerOpenSearch)dockerOpenSearch.getDockerOS()).unpause());
        this.assertThatServerStartCorrectly(server);
    }

    private void waitToStartContainer(long waitingTime, Runnable action) {
        this.executorService.submit(() -> {
            try {
                Thread.sleep(waitingTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            action.run();
        });
    }

    private void assertThatServerStartCorrectly(GuiceJamesServer server) throws Exception {
        server.start();
        this.socketChannel.connect(new InetSocketAddress("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()));
        Assertions.assertThat((String)this.getServerConnectionResponse(this.socketChannel)).startsWith((CharSequence)"* OK JAMES IMAP4rev1 Server");
    }

    private String getServerConnectionResponse(SocketChannel socketChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
        socketChannel.read(byteBuffer);
        byte[] bytes = byteBuffer.array();
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

