/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.util.EnumSet;
import java.util.List;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.StartUpChecksPerformer;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.modules.TestJMAPServerModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

class JamesCapabilitiesServerTest {
    private static final MailboxManager mailboxManager = (MailboxManager)Mockito.mock(MailboxManager.class);
    @RegisterExtension
    static JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{binder -> binder.bind(MailboxManager.class).toInstance((Object)mailboxManager)})).disableAutoStart().build();

    JamesCapabilitiesServerTest() {
    }

    @Test
    void startShouldFailWhenNoMoveCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)false);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.SearchCapabilities.class));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldFailWhenNoACLCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)false);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.SearchCapabilities.class));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldFailWhenNoAttachmentSearchCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.complementOf(EnumSet.of(MailboxManager.SearchCapabilities.Attachment)));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldFailWhenNoAttachmentFileNameSearchCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.complementOf(EnumSet.of(MailboxManager.SearchCapabilities.AttachmentFileName)));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldFailWhenNoMultimailboxSearchCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.complementOf(EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch)));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldFailWhenNoUniqueIDCapability(GuiceJamesServer server) {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.complementOf(EnumSet.of(MailboxManager.MessageCapabilities.UniqueID)));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.SearchCapabilities.class));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"MailboxCapabilitiesForJMAP"}));
    }

    @Test
    void startShouldSucceedWhenRequiredCapabilities(GuiceJamesServer server) throws Exception {
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL)).thenReturn((Object)true);
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.allOf(MailboxManager.SearchCapabilities.class));
        Assertions.assertThatCode(() -> ((GuiceJamesServer)server).start()).doesNotThrowAnyException();
        Assertions.assertThat((boolean)server.isStarted()).isTrue();
    }
}

