/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.time.Duration;
import java.util.Optional;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.backends.opensearch.DockerOpenSearchSingleton;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DockerOpenSearchExtension
implements GuiceModuleTestExtension {
    private final DockerOpenSearch dockerOpenSearch;
    private Optional<Duration> requestTimeout;

    public DockerOpenSearchExtension() {
        this(DockerOpenSearchSingleton.INSTANCE);
    }

    public DockerOpenSearchExtension withRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = Optional.of(requestTimeout);
        return this;
    }

    public DockerOpenSearchExtension(DockerOpenSearch dockerOpenSearch) {
        this.dockerOpenSearch = dockerOpenSearch;
        this.requestTimeout = Optional.empty();
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.getDockerOS().start();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (!this.getDockerOS().isRunning()) {
            this.getDockerOS().unpause();
        }
        this.await();
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.getDockerOS().cleanUpData();
    }

    public Module getModule() {
        return binder -> binder.bind(OpenSearchConfiguration.class).toInstance((Object)this.getOpenSearchConfigurationForDocker());
    }

    public void await() {
        this.getDockerOS().flushIndices();
    }

    private OpenSearchConfiguration getOpenSearchConfigurationForDocker() {
        return OpenSearchConfiguration.builder().addHost(this.getDockerOS().getHttpHost()).requestTimeout(this.requestTimeout).build();
    }

    public DockerOpenSearch getDockerOS() {
        return this.dockerOpenSearch;
    }
}

