/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Modules;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.GuiceModuleTestRule;
import org.apache.james.backends.cassandra.DockerCassandra;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.modules.mailbox.KeyspacesConfiguration;
import org.apache.james.server.CassandraTruncateTableTask;
import org.apache.james.util.Host;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.GenericContainer;

public class DockerCassandraRule
implements GuiceModuleTestRule {
    private org.apache.james.backends.cassandra.DockerCassandraRule cassandraContainer = new org.apache.james.backends.cassandra.DockerCassandraRule().allowRestart();

    public Statement apply(Statement base, Description description) {
        return this.cassandraContainer.apply(base, description);
    }

    public Module getModule() {
        return Modules.combine((Module[])new Module[]{binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandra.configurationBuilder((Host[])new Host[]{this.cassandraContainer.getHost()}).maxRetry(20).minDelay(5000).build()), binder -> binder.bind(KeyspacesConfiguration.class).toInstance((Object)KeyspacesConfiguration.builder().keyspace("testing").cacheKeyspace("testing_cache").replicationFactor(1).disableDurableWrites().build()), binder -> Multibinder.newSetBinder((Binder)binder, CleanupTasksPerformer.CleanupTask.class).addBinding().to(CassandraTruncateTableTask.class)});
    }

    public String getIp() {
        return this.cassandraContainer.getIp();
    }

    public Host getHost() {
        return this.cassandraContainer.getHost();
    }

    public Integer getMappedPort(int originalPort) {
        return this.cassandraContainer.getBindingPort();
    }

    public void start() {
        this.cassandraContainer.start();
    }

    public void stop() {
        this.cassandraContainer.stop();
    }

    public GenericContainer<?> getRawContainer() {
        return this.cassandraContainer.getRawContainer();
    }

    public void pause() {
        this.cassandraContainer.pause();
    }

    public void unpause() {
        this.cassandraContainer.unpause();
    }
}

