/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerCassandraRule;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.backends.cassandra.DockerCassandra;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.util.Host;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.DockerClientFactory;

class CassandraNodeConfTest {
    private static final int CASSANDRA_PORT = 9042;
    private SocketChannel socketChannel;

    CassandraNodeConfTest() {
    }

    private static JamesServerBuilder extensionBuilder() {
        return TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).disableAutoStart();
    }

    private static String getDockerHostIp() {
        DockerClientFactory clientFactory = DockerClientFactory.instance();
        clientFactory.client();
        return clientFactory.dockerHostIpAddress();
    }

    @BeforeEach
    void setUp() throws IOException {
        this.socketChannel = SocketChannel.open();
    }

    @AfterEach
    void after() throws IOException {
        this.socketChannel.close();
    }

    private void assertThatServerStartCorrectly(GuiceJamesServer server) throws Exception {
        server.start();
        this.socketChannel.connect(new InetSocketAddress("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()));
        Assertions.assertThat((String)this.getServerConnectionResponse(this.socketChannel)).startsWith((CharSequence)"* OK JAMES IMAP4rev1 Server");
    }

    private String getServerConnectionResponse(SocketChannel socketChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
        socketChannel.read(byteBuffer);
        byte[] bytes = byteBuffer.array();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Nested
    class UseMappedPort {
        private final DockerCassandraRule cassandra = new DockerCassandraRule();
        @RegisterExtension
        JamesServerExtension testExtension = CassandraNodeConfTest.extensionBuilder().overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandra.configurationBuilder((Host[])new Host[]{Host.from((String)CassandraNodeConfTest.getDockerHostIp(), (int)this.cassandra.getMappedPort(9042))}).build())).build();

        UseMappedPort() {
        }

        @Test
        void configShouldWorkWithNonDefaultPort(GuiceJamesServer server) throws Exception {
            CassandraNodeConfTest.this.assertThatServerStartCorrectly(server);
        }
    }

    @Nested
    class OneFailedNode {
        String unreachableNode = "10.2.3.42";
        private final DockerCassandraRule cassandra = new DockerCassandraRule();
        @RegisterExtension
        JamesServerExtension testExtension = CassandraNodeConfTest.extensionBuilder().overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandra.configurationBuilder((Host[])new Host[]{Host.from((String)this.unreachableNode, (int)9042), this.cassandra.getHost()}).build())).build();

        OneFailedNode() {
        }

        @Test
        void serverShouldStartServiceWhenNodeIsReachable(GuiceJamesServer server) throws Exception {
            CassandraNodeConfTest.this.assertThatServerStartCorrectly(server);
        }
    }

    @Nested
    class NormalBehaviour {
        @RegisterExtension
        JamesServerExtension testExtension = CassandraNodeConfTest.extensionBuilder().build();

        NormalBehaviour() {
        }

        @Test
        void serverShouldStartServiceWhenNodeIsReachable(GuiceJamesServer server) throws Exception {
            CassandraNodeConfTest.this.assertThatServerStartCorrectly(server);
        }
    }
}

