/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.time.Duration;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.MailRepositoryProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMailRepositoryIntegrationTest {
    private static final MailRepositoryUrl SENDER_DENIED_URL = MailRepositoryUrl.from((String)"cassandra://var/mail/sender-denied/");
    private static final Duration ONE_MILLISECOND = Duration.ofMillis(1L);
    private static ConditionFactory await = Awaitility.with().pollInterval(Durations.FIVE_HUNDRED_MILLISECONDS).and().with().pollDelay(ONE_MILLISECOND).await();
    private SMTPMessageSender smtpMessageSender = new SMTPMessageSender("other.com");
    @RegisterExtension
    static JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).build();

    CassandraMailRepositoryIntegrationTest() {
    }

    @Test
    void deniedSenderMailShouldBeStoredInCassandraMailRepositoryWhenConfigured(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.com").addUser("user@domain.com", "secret");
        this.smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("denied@other.com", "user@domain.com");
        MailRepositoryProbeImpl repositoryProbe = (MailRepositoryProbeImpl)server.getProbe(MailRepositoryProbeImpl.class);
        await.until(() -> repositoryProbe.getRepositoryMailCount(SENDER_DENIED_URL) == 1L);
    }
}

