/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.time.Duration;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerConcreteContract;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.core.Domain;
import org.apache.james.data.LdapTestExtension;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SMTPSendingException;
import org.apache.james.utils.SpoolerProbe;
import org.apache.james.utils.TestIMAPClient;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraLdapJamesServerTest
implements JamesServerConcreteContract {
    private static Duration slowPacedPollInterval = Durations.ONE_HUNDRED_MILLISECONDS;
    private static ConditionFactory calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
    private IMAPClient imapClient = new IMAPClient();
    @RegisterExtension
    TestIMAPClient testIMAPClient = new TestIMAPClient();
    SMTPMessageSender messageSender = new SMTPMessageSender(Domain.LOCALHOST.asString());
    static LdapTestExtension ldap = new LdapTestExtension();
    @RegisterExtension
    static JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.forConfiguration(configuration -> configuration.searchConfiguration(SearchConfiguration.openSearch()).usersRepository(UsersRepositoryModuleChooser.Implementation.LDAP)).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)ldap).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).build();

    CassandraLdapJamesServerTest() {
    }

    @Test
    void userFromLdapShouldLoginViaImapProtocol(GuiceJamesServer server) throws Exception {
        this.imapClient.connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort());
        Assertions.assertThat((boolean)this.imapClient.login(DockerLdapSingleton.JAMES_USER.asString(), "secret")).isTrue();
    }

    @Test
    void mailsShouldBeWellReceivedBeforeFirstUserConnectionWithLdap(GuiceJamesServer server) throws Exception {
        this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@any.com", DockerLdapSingleton.JAMES_USER.asString() + "@localhost");
        calmlyAwait.until(() -> ((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished());
        this.testIMAPClient.connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(DockerLdapSingleton.JAMES_USER, "secret").select("INBOX").awaitMessage(calmlyAwait);
    }

    @Test
    void receivingMailShouldIssueAnSmtpErrorWhenLdapIsNotAvailable(GuiceJamesServer server) {
        try {
            ldap.getLdapRule().stop();
            Assertions.assertThatThrownBy(() -> this.messageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@any.com", DockerLdapSingleton.JAMES_USER.asString() + "@localhost")).isInstanceOf(SMTPSendingException.class);
        }
        finally {
            ldap.getLdapRule().start();
        }
    }
}

