/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.io.IOException;
import org.apache.james.AggregateGuiceModuleTestRule;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.DockerOpenSearchRule;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestRule;
import org.apache.james.SearchConfiguration;
import org.apache.james.TempFilesystemTestRule;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CassandraJmapTestRule
implements TestRule {
    private final TemporaryFolder temporaryFolder;
    private final GuiceModuleTestRule guiceModuleTestRule;
    private final DockerOpenSearchRule dockerOpenSearchRule;

    public static CassandraJmapTestRule defaultTestRule() {
        return new CassandraJmapTestRule(new GuiceModuleTestRule[0]);
    }

    public CassandraJmapTestRule(GuiceModuleTestRule ... guiceModuleTestRule) {
        TempFilesystemTestRule tempFilesystemTestRule = new TempFilesystemTestRule();
        this.dockerOpenSearchRule = new DockerOpenSearchRule();
        this.temporaryFolder = tempFilesystemTestRule.getTemporaryFolder();
        this.guiceModuleTestRule = AggregateGuiceModuleTestRule.of((GuiceModuleTestRule[])guiceModuleTestRule).aggregate(new GuiceModuleTestRule[]{this.dockerOpenSearchRule}).aggregate(new GuiceModuleTestRule[]{tempFilesystemTestRule});
    }

    public GuiceJamesServer jmapServer(Module ... additionals) throws IOException {
        CassandraJamesServerConfiguration configuration = CassandraJamesServerConfiguration.builder().workingDirectory(this.temporaryFolder.newFolder()).configurationFromClasspath().searchConfiguration(SearchConfiguration.openSearch()).build();
        return CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{this.guiceModuleTestRule.getModule()}).overrideWith(new Module[]{binder -> binder.bind(CleanupTasksPerformer.class).asEagerSingleton()}).overrideWith(new Module[]{binder -> binder.bind(WebAdminConfiguration.class).toInstance((Object)WebAdminConfiguration.TEST_CONFIGURATION)}).overrideWith(additionals);
    }

    public Statement apply(Statement base, Description description) {
        return this.guiceModuleTestRule.apply(base, description);
    }

    public void await() {
        this.guiceModuleTestRule.await();
    }
}

