/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.mailbox.CassandraCacheSessionModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CacheSessionTest {
    private static final String TABLE_NAME = "tablename";
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraJamesServerConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().searchConfiguration(SearchConfiguration.openSearch()).build()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).combineWith(new Module[]{new CassandraCacheSessionModule()})).overrideServerModule(binder -> Multibinder.newSetBinder((Binder)binder, CassandraModule.class, (Annotation)Names.named((String)"cache")).addBinding().toInstance((Object)CassandraModule.table((String)TABLE_NAME).comment("Testing table").statement(statement -> types -> statement.withPartitionKey("id", DataTypes.TIMEUUID).withClusteringColumn("clustering", DataTypes.BIGINT)).build())).overrideServerModule(binder -> Multibinder.newSetBinder((Binder)binder, StartUpCheck.class).addBinding().to(CacheSessionTestCheck.class)).disableAutoStart().build();

    CacheSessionTest() {
    }

    @Test
    void cacheTableShouldBeWellCreated(GuiceJamesServer jamesServer) {
        Assertions.assertThatCode(() -> ((GuiceJamesServer)jamesServer).start()).doesNotThrowAnyException();
    }

    static class CacheSessionTestCheck
    implements StartUpCheck {
        static final String NAME = "CacheSessionTest-check";
        private final CqlSession cacheSession;

        @Inject
        CacheSessionTestCheck(@Named(value="cache") CqlSession cacheSession) {
            this.cacheSession = cacheSession;
        }

        public StartUpCheck.CheckResult check() {
            try {
                this.cacheSession.execute((Statement)QueryBuilder.selectFrom((String)CacheSessionTest.TABLE_NAME).all().build());
                return StartUpCheck.CheckResult.builder().checkName(NAME).resultType(StartUpCheck.ResultType.GOOD).build();
            }
            catch (Exception e) {
                return StartUpCheck.CheckResult.builder().checkName(NAME).resultType(StartUpCheck.ResultType.BAD).description(String.format("%s do not exist", CacheSessionTest.TABLE_NAME)).build();
            }
        }

        public String checkName() {
            return NAME;
        }
    }
}

