/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.CreationException;
import com.google.inject.Module;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerConcreteContract;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.backends.cassandra.DockerCassandra;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.util.Host;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class AuthenticatedCassandraJamesServerTest {
    private static final String CASSANDRA_USER = "james_testing";
    private static final String VALID_PASSWORD = "james_testing_password";
    private static final String INVALID_PASSWORD = "bad";
    private final CassandraExtension cassandraExtension = new CassandraExtension();

    AuthenticatedCassandraJamesServerTest() {
    }

    @Nested
    class AuthenticationFailureTest {
        @RegisterExtension
        JamesServerExtension testExtension;

        AuthenticationFailureTest() {
            this.testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)AuthenticatedCassandraJamesServerTest.this.cassandraExtension).disableAutoStart().server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandra.configurationBuilder((Host[])new Host[]{AuthenticatedCassandraJamesServerTest.this.cassandraExtension.getCassandra().getHost()}).username(AuthenticatedCassandraJamesServerTest.CASSANDRA_USER).password(AuthenticatedCassandraJamesServerTest.INVALID_PASSWORD).maxRetry(1).build())).build();
        }

        @Test
        void startShouldFailOnBadPassword(GuiceJamesServer jamesServer) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)jamesServer).start()).isInstanceOf(CreationException.class)).hasStackTraceContaining("com.datastax.oss.driver.api.core.auth.AuthenticationException");
        }
    }

    @Nested
    class AuthenticationTest
    implements JamesServerConcreteContract {
        @RegisterExtension
        JamesServerExtension testExtension;

        AuthenticationTest() {
            this.testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)AuthenticatedCassandraJamesServerTest.this.cassandraExtension).server(CassandraJamesServerMain::createServer).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandra.configurationBuilder((Host[])new Host[]{AuthenticatedCassandraJamesServerTest.this.cassandraExtension.getCassandra().getHost()}).username(AuthenticatedCassandraJamesServerTest.CASSANDRA_USER).password(AuthenticatedCassandraJamesServerTest.VALID_PASSWORD).build())).build();
        }
    }
}

