/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore$;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuples;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsFunction$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tms!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0006\u0001\u000b\u0011B \t\u000f\r\u000b!\u0019!C\u0001\t\"1\u0001*\u0001Q\u0001\n\u0015CQ!S\u0001\u0005\n)3Aa\r\u0013\u0001I\"AA\u000f\u0003B\u0001B\u0003%Q\u000f\u0003\u0005y\u0011\t\u0005\t\u0015!\u0003z\u0011)\t\t\u0002\u0003B\u0001B\u0003%\u00111\u0003\u0005\u0007w!!\t!!\t\t\u0013\u0005U\u0002B1A\u0005\n\u0005]\u0002\u0002CA\u001f\u0011\u0001\u0006I!!\u000f\t\u0013\u0005}\u0002B1A\u0005\n\u0005\u0005\u0003bBA\"\u0011\u0001\u0006Ia\u0013\u0005\n\u0003\u000bB!\u0019!C\u0005\u0003\u0003Bq!a\u0012\tA\u0003%1\nC\u0004\u0002J!!\t%a\u0013\t\u000f\u0005%\u0003\u0002\"\u0011\u0002\u0006\"9\u0011\u0011\n\u0005\u0005B\u0005]\u0005bBA%\u0011\u0011\u0005\u0013Q\u0015\u0005\b\u0003\u0013BA\u0011IAg\u0011\u001d\t9\u000e\u0003C\u0005\u00033Dq!a=\t\t\u0013\t)\u0010C\u0004\u0002J!!\tEa\u0002\t\u000f\tE\u0001\u0002\"\u0011\u0003\u0014!9!Q\u0004\u0005\u0005B\t}\u0001b\u0002B\u0013\u0011\u0011\u0005#q\u0005\u0005\b\u0005_AA\u0011\tB\u0019\u0011\u001d\u0011\u0019\u0004\u0003C!\u0005kAqA!\u0011\t\t\u0003\u0012\u0019\u0005C\u0004\u0003P!!\tE!\u0015\t\u000f\tU\u0003\u0002\"\u0011\u0003X\u00051B)\u001a#va2L7-\u0019;j_:\u0014En\u001c2Ti>\u0014XM\u0003\u0002&M\u0005iA-\u001a3va2L7-\u0019;j_:T!a\n\u0015\u0002\t\tdwN\u0019\u0006\u0003S)\naa]3sm\u0016\u0014(BA\u0016-\u0003\u0015Q\u0017-\\3t\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001A\u0011!'A\u0007\u0002I\t1B)\u001a#va2L7-\u0019;j_:\u0014En\u001c2Ti>\u0014Xm\u0005\u0002\u0002kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0019\u0002+1\u000b%,W0S\u000bN{UKU\"F?\u000ecU)\u0011(V!V\tq\b\u0005\u00027\u0001&\u0011\u0011i\u000e\u0002\b\u0005>|G.Z1o\u0003Ya\u0015IW-`%\u0016\u001bv*\u0016*D\u000b~\u001bE*R!O+B\u0003\u0013A\u0004$J\u0019\u0016{F\u000b\u0013*F'\"{E\nR\u000b\u0002\u000bB\u0011aGR\u0005\u0003\u000f^\u00121!\u00138u\u0003=1\u0015\nT#`)\"\u0013Vi\u0015%P\u0019\u0012\u0003\u0013\u0001\u00052bg\u0016,enY8eS:<gI]8n)\tYu\u000b\u0005\u0002M+6\tQJ\u0003\u0002O\u001f\u0006\u0011\u0011n\u001c\u0006\u0003!F\u000baaY8n[>t'B\u0001*T\u0003\u00199wn\\4mK*\tA+A\u0002d_6L!AV'\u0003\u0019\t\u000b7/Z#oG>$\u0017N\\4\t\u000ba;\u0001\u0019A-\u0002\u0019\u0015t7m\u001c3j]\u001e$\u0016\u0010]3\u0011\u0005i\u000bgBA.`!\tav'D\u0001^\u0015\tq\u0006'\u0001\u0004=e>|GOP\u0005\u0003A^\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001mN\n\u0004\u0011\u0015l\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011a\u0017M\\4\u000b\u0003)\fAA[1wC&\u0011An\u001a\u0002\u0007\u001f\nTWm\u0019;\u0011\u00059\u0014X\"A8\u000b\u0005A\f\u0018aA1qS*\u0011qEK\u0005\u0003g>\u0014\u0011B\u00117pEN#xN]3\u0002\u0019\tdwNY*u_J,G)Q(\u0011\u000594\u0018BA<p\u00051\u0011En\u001c2Ti>\u0014X\rR!P\u0003E!WMZ1vYR\u0014UoY6fi:\u000bW.\u001a\t\u0003]jL!a_8\u0003\u0015\t+8m[3u\u001d\u0006lW\r\u000b\u0004\u000b{\u0006-\u0011Q\u0002\t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005\u0015\u0011a\u00026bW\u0006\u0014H/Y\u0005\u0004\u0003\u0013y(!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017EAA\b\u00035!WMZ1vYR\u0014UoY6fi\u0006i!\r\\8c\u0013\u00124\u0015m\u0019;pef\u0004B!!\u0006\u0002\u001c9\u0019a.a\u0006\n\u0007\u0005eq.\u0001\u0004CY>\u0014\u0017\nZ\u0005\u0005\u0003;\tyBA\u0004GC\u000e$xN]=\u000b\u0007\u0005eq\u000e\u0006\u0005\u0002$\u0005\u0015\u0012qEA\u0016!\t\u0011\u0004\u0002C\u0003u\u0019\u0001\u0007Q\u000fC\u0003y\u0019\u0001\u0007\u0011\u0010K\u0004\u0002(u\fY!!\u0004\t\u000f\u0005EA\u00021\u0001\u0002\u0014!\u001aA\"a\f\u0011\u0007y\f\t$C\u0002\u00024}\u0014a!\u00138kK\u000e$\u0018a\t%B'\"{&\tT(C?&#u,\u0012(D\u001f\u0012KejR0U3B+u\f\u0015*P!\u0016\u0013F+W\u000b\u0003\u0003s\u00012AZA\u001e\u0013\t\u0011w-\u0001\u0013I\u0003NCuL\u0011'P\u0005~KEiX#O\u0007>#\u0015JT$`)f\u0003Vi\u0018)S\u001fB+%\u000bV-!\u0003uA\u0015i\u0015%`\u00052{%iX%E?\u0016s5i\u0014#J\u001d\u001e{F)\u0012$B+2#V#A&\u0002=!\u000b5\u000bS0C\u0019>\u0013u,\u0013#`\u000b:\u001bu\nR%O\u000f~#UIR!V\u0019R\u0003\u0013\u0001\u00042bg\u0016,enY8eS:<\u0017!\u00042bg\u0016,enY8eS:<\u0007%\u0001\u0003tCZ,G\u0003CA'\u0003?\n\u0019'a\u001d\u0011\r\u0005=\u0013QKA-\u001b\t\t\tFC\u0002\u0002T9\nqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0005\u0003/\n\tFA\u0005Qk\nd\u0017n\u001d5feB\u0019a.a\u0017\n\u0007\u0005usN\u0001\u0004CY>\u0014\u0017\n\u001a\u0005\u0007\u0003C\u001a\u0002\u0019A=\u0002\u0015\t,8m[3u\u001d\u0006lW\rC\u0004\u0002fM\u0001\r!a\u001a\u0002\t\u0011\fG/\u0019\t\u0006m\u0005%\u0014QN\u0005\u0004\u0003W:$!B!se\u0006L\bc\u0001\u001c\u0002p%\u0019\u0011\u0011O\u001c\u0003\t\tKH/\u001a\u0005\b\u0003k\u001a\u0002\u0019AA<\u00035\u0019Ho\u001c:bO\u0016\u0004v\u000e\\5dsB!\u0011\u0011PA@\u001d\rq\u00171P\u0005\u0004\u0003{z\u0017!\u0003\"m_\n\u001cFo\u001c:f\u0013\u0011\t\t)a!\u0003\u001bM#xN]1hKB{G.[2z\u0015\r\tih\u001c\u000b\t\u0003\u001b\n9)!#\u0002\u0016\"1\u0011\u0011\r\u000bA\u0002eDq!!\u001a\u0015\u0001\u0004\tY\t\u0005\u0003\u0002\u000e\u0006EUBAAH\u0015\tq\u0015.\u0003\u0003\u0002\u0014\u0006=%aC%oaV$8\u000b\u001e:fC6Dq!!\u001e\u0015\u0001\u0004\t9\b\u0006\u0005\u0002N\u0005e\u00151TAR\u0011\u0019\t\t'\u0006a\u0001s\"9\u0011QM\u000bA\u0002\u0005u\u0005c\u0001'\u0002 &\u0019\u0011\u0011U'\u0003\u0015\tKH/Z*pkJ\u001cW\rC\u0004\u0002vU\u0001\r!a\u001e\u0015\u0015\u00055\u0013qUAU\u0003W\u000bY\r\u0003\u0004\u0002bY\u0001\r!\u001f\u0005\b\u0003K2\u0002\u0019AA4\u0011\u001d\tiK\u0006a\u0001\u0003_\u000baB\u00197pE&#\u0007K]8wS\u0012,'\u000f\u0005\u0003\u00022\u0006\u001dg\u0002BAZ\u0003wrA!!.\u0002F:!\u0011qWAb\u001d\u0011\tI,!1\u000f\t\u0005m\u0016q\u0018\b\u00049\u0006u\u0016\"A\u0018\n\u00055r\u0013BA\u0016-\u0013\t9#&\u0003\u0002qc&!\u0011\u0011ZAB\u00059\u0011En\u001c2JIB\u0013xN^5eKJDq!!\u001e\u0017\u0001\u0004\t9\b\u0006\u0006\u0002N\u0005=\u0017\u0011[Aj\u0003+Da!!\u0019\u0018\u0001\u0004I\bbBA3/\u0001\u0007\u0011Q\u0014\u0005\b\u0003[;\u0002\u0019AAX\u0011\u001d\t)h\u0006a\u0001\u0003o\n!b^5uQ\ncwNY%e)\u0011\tY.!=\u0011\r\u0005=\u0013QKAo!!\ty.!<\u0002Z\u0005-UBAAq\u0015\u0011\t\u0019/!:\u0002\u0011\u0019,hn\u0019;j_:TA!a:\u0002j\u0006!Q\u000f^5m\u0015\t\tY/A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005=\u0018\u0011\u001d\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002\f\u00061!-Y:fmQ\"B!!\u000f\u0002x\"9\u0011\u0011`\rA\u0002\u0005m\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0011\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001P\u0003\u0011A\u0017m\u001d5\n\t\t\u0015\u0011q \u0002\t\u0011\u0006\u001c\bnQ8eKRQ\u0011Q\nB\u0005\u0005\u0017\u0011iAa\u0004\t\r\u0005\u0005$\u00041\u0001z\u0011\u001d\t)G\u0007a\u0001\u0003\u0017Cq!!,\u001b\u0001\u0004\ty\u000bC\u0004\u0002vi\u0001\r!a\u001e\u0002\u0013I,\u0017\r\u001a\"zi\u0016\u001cHC\u0002B\u000b\u0005/\u0011I\u0002\u0005\u0004\u0002P\u0005U\u0013q\r\u0005\u0007\u0003CZ\u0002\u0019A=\t\u000f\tm1\u00041\u0001\u0002Z\u00051!\r\\8c\u0013\u0012\fAA]3bIR1\u00111\u0012B\u0011\u0005GAa!!\u0019\u001d\u0001\u0004I\bb\u0002B\u000e9\u0001\u0007\u0011\u0011L\u0001\re\u0016\fGMU3bGRLg/\u001a\u000b\u0007\u0005S\u0011YC!\f\u0011\r\u0005=\u0013QKAF\u0011\u0019\t\t'\ba\u0001s\"9!1D\u000fA\u0002\u0005e\u0013\u0001F4fi\u0012+g-Y;mi\n+8m[3u\u001d\u0006lW\rF\u0001z\u00031!W\r\\3uK\n+8m[3u)\u0011\u00119Da\u0010\u0011\r\u0005=\u0013Q\u000bB\u001d!\r1'1H\u0005\u0004\u0005{9'\u0001\u0002,pS\u0012Da!!\u0019 \u0001\u0004I\u0018A\u00023fY\u0016$X\r\u0006\u0004\u0003F\t-#Q\n\t\u0007\u0003\u001f\n)Fa\u0012\u0011\u0007\u0019\u0014I%\u0003\u0002BO\"1\u0011\u0011\r\u0011A\u0002eDqAa\u0007!\u0001\u0004\tI&A\u0006mSN$()^2lKR\u001cHC\u0001B*!\u0015\ty%!\u0016z\u0003%a\u0017n\u001d;CY>\u00147\u000f\u0006\u0003\u0002N\te\u0003BBA1E\u0001\u0007\u0011\u0010")
public class DeDuplicationBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;
    private final String HASH_BLOB_ID_ENCODING_TYPE_PROPERTY;
    private final BaseEncoding HASH_BLOB_ID_ENCODING_DEFAULT;
    private final BaseEncoding baseEncoding;

    public static int FILE_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD();
    }

    public static boolean LAZY_RESOURCE_CLEANUP() {
        return DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP();
    }

    public Publisher<BlobId> save(BucketName bucketName, String data, BlobStore.StoragePolicy storagePolicy) {
        return super.save(bucketName, data, storagePolicy);
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readBytes(bucketName, blobId, storagePolicy);
    }

    public InputStream read(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.read(bucketName, blobId, storagePolicy);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readReactive(bucketName, blobId, storagePolicy);
    }

    private String HASH_BLOB_ID_ENCODING_TYPE_PROPERTY() {
        return this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY;
    }

    private BaseEncoding HASH_BLOB_ID_ENCODING_DEFAULT() {
        return this.HASH_BLOB_ID_ENCODING_DEFAULT;
    }

    private BaseEncoding baseEncoding() {
        return this.baseEncoding;
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return this.save(bucketName, new ByteArrayInputStream(data), blobIdProvider, storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.fromCallable(() -> data.openStream()).using((Function1 & Serializable)stream -> SMono$.MODULE$.apply(blobIdProvider.apply(stream)).subscribeOn(Schedulers.boundedElastic()).map((Function1 & Serializable)javaTuple2 -> reactor.core.scala.publisher.package$.MODULE$.tupleTwo2ScalaTuple2(javaTuple2)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlobId blobId = (BlobId)tuple2._1();
                InputStream inputStream = (InputStream)tuple2._2();
                return SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, inputStream)).then(SMono$.MODULE$.just((Object)blobId));
            }
            throw new MatchError((Object)tuple2);
        }), (Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    private Publisher<reactor.util.function.Tuple2<BlobId, InputStream>> withBlobId(InputStream data) {
        HashingInputStream hashingInputStream = new HashingInputStream(Hashing.sha256(), data);
        Callable<FileBackedOutputStream> ressourceSupplier = () -> new FileBackedOutputStream(DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD());
        Function1 & Serializable sourceSupplier = (Function1 & Serializable)fileBackedOutputStream -> SMono$.MODULE$.fromCallable(() -> {
            IOUtils.copy((InputStream)hashingInputStream, (OutputStream)fileBackedOutputStream);
            return new Tuple2((Object)$this.blobIdFactory.of(this.base64(hashingInputStream.hash())), (Object)fileBackedOutputStream.asByteSource().openStream());
        }).asJava();
        return Mono.using(ressourceSupplier, (Function)RichFunction1AsFunction$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaFunction((Function1)sourceSupplier)), (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer((Function1 & Serializable)fileBackedOutputStream -> {
            fileBackedOutputStream.reset();
            return BoxedUnit.UNIT;
        })), (boolean)DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP()).subscribeOn(Schedulers.boundedElastic()).map(x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlobId blobId = (BlobId)tuple2._1();
                InputStream data = (InputStream)tuple2._2();
                return Tuples.of((Object)blobId, (Object)data);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String base64(HashCode hashCode) {
        byte[] bytes = hashCode.asBytes();
        return this.baseEncoding().encode(bytes);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return Mono.from((Publisher)blobIdProvider.apply(data)).subscribeOn(Schedulers.boundedElastic()).flatMap(tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (InputStream)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())).asJava());
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public DeDuplicationBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
        this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY = "james.blob.id.hash.encoding";
        this.HASH_BLOB_ID_ENCODING_DEFAULT = BaseEncoding.base64Url();
        this.baseEncoding = (BaseEncoding)Option$.MODULE$.apply((Object)System.getProperty(this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY())).map((Function1 & Serializable)encodingType -> DeDuplicationBlobStore$.MODULE$.org$apache$james$server$blob$deduplication$DeDuplicationBlobStore$$baseEncodingFrom((String)encodingType)).getOrElse((Function0 & Serializable)() -> this.HASH_BLOB_ID_ENCODING_DEFAULT());
    }
}

