/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import java.time.Instant;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.json.JsonGenericSerializer;
import org.apache.james.server.blob.deduplication.BlobGCTask;
import org.apache.james.server.blob.deduplication.BlobGCTaskAdditionalInformationDTO;
import org.apache.james.util.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobGCTaskAdditionalInformationDTOTest {
    BlobGCTaskAdditionalInformationDTOTest() {
    }

    @Test
    void shouldMatchJsonSerializationContract() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)BlobGCTaskAdditionalInformationDTO.SERIALIZATION_MODULE).bean((Object)new BlobGCTask.AdditionalInformation(1L, 2L, 3L, 4L, 5L, 0.8, Instant.parse("2007-12-03T10:15:30.00Z"), 100)).json(ClassLoaderUtils.getSystemResourceAsString((String)"json/blobGC.additionalInformation.json")).verify();
    }

    @Test
    void shouldDeserializeLegacyData() throws Exception {
        BlobGCTask.AdditionalInformation gcTask = (BlobGCTask.AdditionalInformation)JsonGenericSerializer.forModules((DTOModule[])new DTOModule[]{BlobGCTaskAdditionalInformationDTO.SERIALIZATION_MODULE}).withoutNestedType().deserialize(ClassLoaderUtils.getSystemResourceAsString((String)"json/blobGC-legacy.additionalInformation.json"));
        Assertions.assertThat((Object)gcTask).isEqualToComparingFieldByFieldRecursively((Object)new BlobGCTask.AdditionalInformation(1L, 2L, 3L, 4L, 5L, 0.8, Instant.parse("2007-12-03T10:15:30.00Z"), 1000));
    }
}

