/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.TestBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreFixture;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraDefaultBucketDAOTest {
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobModule.MODULE);
    private CassandraDefaultBucketDAO testee;

    CassandraDefaultBucketDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new CassandraDefaultBucketDAO((CqlSession)cassandraCluster.getCassandraCluster().getConf(), (BlobId.Factory)new TestBlobId.Factory());
    }

    @Test
    void readPartShouldReturnEmptyWhenNone() {
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldReturnPreviouslySavedData() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).contains((Object)ByteBuffer.wrap(CassandraBlobStoreFixture.DATA));
    }

    @Test
    void readPartShouldNotReturnContentOfOtherParts() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 43).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldReturnLatestValue() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA_2), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).contains((Object)ByteBuffer.wrap(CassandraBlobStoreFixture.DATA_2));
    }

    @Test
    void selectRowCountShouldReturnEmptyByDefault() {
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void selectRowCountShouldReturnPreviouslySavedValue() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BLOB_ID, 17).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).contains((Object)17);
    }

    @Test
    void selectRowCountShouldNotReturnOtherBlobIdValue() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BLOB_ID, 17).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BLOB_ID_2).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void deletePositionShouldNotThrowWhenMissing() {
        Assertions.assertThatCode(() -> this.testee.deletePosition(CassandraBlobStoreFixture.BLOB_ID).block()).doesNotThrowAnyException();
    }

    @Test
    void deletePartShouldNotThrowWhenMissing() {
        Assertions.assertThatCode(() -> this.testee.deleteParts(CassandraBlobStoreFixture.BLOB_ID).block()).doesNotThrowAnyException();
    }

    @Test
    void selectRowCountShouldNotReturnDeletedData() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BLOB_ID, 17).block();
        this.testee.deletePosition(CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void readPartShouldNotReturnDeletedItem() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.deleteParts(CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldNotReturnDeletedItems() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BLOB_ID, 43).block();
        this.testee.deleteParts(CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Optional maybeBytes2 = this.testee.readPart(CassandraBlobStoreFixture.BLOB_ID, 43).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
        Assertions.assertThat((Optional)maybeBytes2).isEmpty();
    }
}

