/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.MetricableBlobStoreContract;
import org.apache.james.blob.api.ObjectStoreException;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.util.io.ZeroedInputStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface CassandraBlobStoreContract
extends MetricableBlobStoreContract {
    public static final int MULTIPLE_CHUNK_SIZE = 3;
    public static final int CHUNK_SIZE = 10240;

    public CassandraDefaultBucketDAO defaultBucketDAO();

    @Test
    default public void readBytesShouldReturnSplitSavedDataByChunk() {
        String longString = Strings.repeat((String)"0123456789\n", (int)3);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        byte[] bytes = (byte[])Mono.from((Publisher)this.testee().readBytes(this.testee().getDefaultBucketName(), blobId)).block();
        Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo(longString);
    }

    @Test
    default public void readBytesShouldNotReturnInvalidResultsWhenPartialDataPresent() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPart(blobId, 1)).thenReturn((Object)Mono.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Mono.from((Publisher)this.testee().readBytes(this.testee().getDefaultBucketName(), blobId)).block()).isInstanceOf(ObjectStoreException.class)).hasMessageContaining("Missing blob part for blobId");
    }

    @Test
    default public void readShouldNotReturnInvalidResultsWhenPartialDataPresent() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPart(blobId, 1)).thenReturn((Object)Mono.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IOUtils.toString((InputStream)this.testee().read(this.testee().getDefaultBucketName(), blobId), (Charset)StandardCharsets.UTF_8)).isInstanceOf(ObjectStoreException.class)).hasMessageContaining("Missing blob part for blobId");
    }

    @Test
    default public void deleteBucketShouldThrowWhenDeletingDefaultBucket() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testee().deleteBucket(this.testee().getDefaultBucketName())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Deleting the default bucket is forbidden");
    }

    @Test
    default public void blobStoreShouldSupport100MBBlob() throws IOException {
        ZeroedInputStream data = new ZeroedInputStream(100000000);
        HashingInputStream writeHash = new HashingInputStream(Hashing.sha256(), (InputStream)data);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), (InputStream)writeHash, BlobStore.StoragePolicy.LOW_COST)).block();
        InputStream bytes = this.testee().read(this.testee().getDefaultBucketName(), blobId);
        HashingInputStream readHash = new HashingInputStream(Hashing.sha256(), bytes);
        this.consumeStream((InputStream)readHash);
        Assertions.assertThat((String)readHash.hash().toString()).isEqualTo(writeHash.hash().toString());
    }

    private void consumeStream(InputStream tmpMsgIn) throws IOException {
        byte[] discard = new byte[4096];
        while (tmpMsgIn.read(discard) != -1) {
        }
    }
}

