/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.mailet.ContractMailTest;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class FakeMailTest
extends ContractMailTest {
    public FakeMail newMail() {
        try {
            return FakeMail.builder().name("mail").build();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void beanShouldRespectBeanContract() {
        EqualsVerifier.forClass(FakeMail.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).withPrefabValues(MimeMessage.class, (Object)((MimeMessage)Mockito.mock(MimeMessage.class)), (Object)((MimeMessage)Mockito.mock(MimeMessage.class))).verify();
    }

    @Test
    public void getMaybeSenderShouldHandleNullSender() throws MessagingException {
        Assertions.assertThat((Object)FakeMail.builder().name("mail").sender(MailAddress.nullSender()).build().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    public void getMaybeSenderShouldHandleNoSender() throws MessagingException {
        Assertions.assertThat((Object)FakeMail.builder().name("mail").build().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    public void getMaybeSenderShouldHandleSender() throws MessagingException {
        Assertions.assertThat((Object)FakeMail.builder().name("mail").sender(MailAddressFixture.SENDER).build().getMaybeSender()).isEqualTo((Object)MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
    }

    @Test
    public void hasSenderShouldReturnFalseWhenSenderIsNull() throws MessagingException {
        Assertions.assertThat((boolean)FakeMail.builder().name("mail").sender(MailAddress.nullSender()).build().hasSender()).isFalse();
    }

    @Test
    public void hasSenderShouldReturnFalseWhenSenderIsNotSpecified() throws MessagingException {
        Assertions.assertThat((boolean)FakeMail.builder().name("mail").build().hasSender()).isFalse();
    }

    @Test
    public void hasSenderShouldReturnTrueWhenSenderIsSpecified() throws MessagingException {
        Assertions.assertThat((boolean)FakeMail.builder().name("mail").sender(MailAddressFixture.SENDER).build().hasSender()).isTrue();
    }
}

