/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;

public class MailUtil {
    public static final String SENDER = "test@james.apache.org";
    public static final String RECIPIENT = "test2@james.apache.org";
    private static int m_counter = 0;

    public static String newId() {
        return "MockMailUtil-ID-" + ++m_counter;
    }

    public static FakeMail createMockMail2Recipients() throws MessagingException {
        return FakeMail.builder().name(MailUtil.newId()).recipients(new MailAddress(SENDER), new MailAddress(RECIPIENT)).build();
    }

    public static FakeMail createMockMail2Recipients(MimeMessage message) throws MessagingException {
        return FakeMail.builder().name(MailUtil.newId()).mimeMessage(message).recipients(new MailAddress(SENDER), new MailAddress(RECIPIENT)).build();
    }

    public static MimeMessage createMimeMessage() throws MessagingException {
        return MailUtil.createMimeMessage(null, null);
    }

    public static MimeMessage createMimeMessageWithSubject(String subject) throws MessagingException {
        return MailUtil.createMimeMessage(null, null, subject);
    }

    public static MimeMessage createMimeMessage(String headerName, String headerValue) throws MessagingException {
        return MailUtil.createMimeMessage(headerName, headerValue, "testmail");
    }

    private static MimeMessage createMimeMessage(String headerName, String headerValue, String subject) throws MessagingException {
        MimeMessageBuilder mimeMessageBuilder = MimeMessageBuilder.mimeMessageBuilder().addToRecipient(RECIPIENT).addFrom(SENDER).setSubject(subject);
        if (headerName != null) {
            mimeMessageBuilder.addHeader(headerName, headerValue);
        }
        return mimeMessageBuilder.build();
    }

    public static String toString(Mail mail, String charset) throws IOException, MessagingException {
        UnsynchronizedByteArrayOutputStream rawMessage = new UnsynchronizedByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage, new String[]{"Bcc", "Content-Length", "Message-ID"});
        return rawMessage.toString(charset);
    }
}

