/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageWrapper;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.HostAddress;
import org.apache.mailet.LookupException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class FakeMailContext
implements MailetContext {
    private final HashMap<AttributeName, Attribute> attributes = new HashMap();
    private final Collection<SentMail> sentMails = new ConcurrentLinkedQueue<SentMail>();
    private final Collection<BouncedMail> bouncedMails = new ConcurrentLinkedQueue<BouncedMail>();
    private final Optional<Logger> logger;
    private final MailAddress postmaster;

    public static Builder builder() {
        return new Builder();
    }

    public static SentMail.Builder sentMailBuilder() {
        return new SentMail.Builder();
    }

    public static SentMail.Builder fromMail(Mail mail) throws MessagingException {
        return FakeMailContext.sentMailBuilder().sender(mail.getMaybeSender().asOptional()).recipients(mail.getRecipients()).message(mail.getMessage()).state(mail.getState()).attributes((List)mail.attributes().collect(ImmutableList.toImmutableList())).fromMailet();
    }

    public static FakeMailContext defaultContext() {
        return FakeMailContext.builder().build();
    }

    private FakeMailContext(Optional<Logger> logger, MailAddress postmaster) {
        this.logger = logger;
        this.postmaster = postmaster;
    }

    public void bounce(Mail mail, String message) throws MessagingException {
        this.bouncedMails.add(new BouncedMail(FakeMailContext.fromMail(mail), message, Optional.empty()));
    }

    public void bounce(Mail mail, String message, MailAddress bouncer) throws MessagingException {
        this.bouncedMails.add(new BouncedMail(FakeMailContext.fromMail(mail), message, Optional.ofNullable(bouncer)));
    }

    @Deprecated
    public Collection<String> getMailServers(Domain host) {
        return null;
    }

    public MailAddress getPostmaster() {
        return this.postmaster;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(AttributeName.of((String)name));
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().stream().map(AttributeName::asString).iterator();
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getServerInfo() {
        return "Mock Server";
    }

    public boolean isLocalServer(Domain domain) {
        return domain.equals((Object)Domain.LOCALHOST);
    }

    @Deprecated
    public boolean isLocalUser(String userAccount) {
        return false;
    }

    public boolean isLocalEmail(MailAddress mailAddress) {
        return false;
    }

    @Deprecated
    public void log(String message) {
        System.out.println(message);
    }

    @Deprecated
    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace(System.out);
    }

    public void removeAttribute(String name) {
    }

    public void sendMail(MimeMessage mimemessage) throws MessagingException {
        this.sentMails.add(FakeMailContext.sentMailBuilder().message(mimemessage).fromMailet().build());
    }

    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage msg) throws MessagingException {
        this.sentMails.add(FakeMailContext.sentMailBuilder().recipients(recipients).sender(sender).message(msg).fromMailet().build());
    }

    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage msg, String state) throws MessagingException {
        this.sentMails.add(FakeMailContext.sentMailBuilder().recipients(recipients).message(msg).state(state).sender(sender).fromMailet().build());
    }

    public void sendMail(Mail mail) throws MessagingException {
        this.sendMail(mail, Optional.ofNullable(mail.getState()).orElse("root"));
    }

    public void sendMail(Mail mail, long delay, TimeUnit unit) throws MessagingException {
        this.sendMail(mail, "root", delay, unit);
    }

    public void sendMail(Mail mail, String state) throws MessagingException {
        mail.setState(state);
        this.sentMails.add(FakeMailContext.fromMail(mail).build());
    }

    public void sendMail(Mail mail, String state, long delay, TimeUnit unit) throws MessagingException {
        mail.setState(state);
        this.sentMails.add(FakeMailContext.fromMail(mail).delay(new Delay(delay, unit)).build());
    }

    @Deprecated
    public void setAttribute(String name, Serializable object) {
        this.setAttribute(Attribute.convertToAttribute((String)name, (Object)object));
    }

    public void setAttribute(Attribute attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    @Deprecated
    public Iterator<HostAddress> getSMTPHostAddresses(Domain domainName) {
        return null;
    }

    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException("MOCKed method");
    }

    public void log(MailetContext.LogLevel level, String message) {
        if (this.logger.isPresent()) {
            switch (level) {
                case INFO: {
                    this.logger.get().info(message);
                    break;
                }
                case WARN: {
                    this.logger.get().warn(message);
                    break;
                }
                case ERROR: {
                    this.logger.get().error(message);
                    break;
                }
                default: {
                    this.logger.get().debug(message);
                    break;
                }
            }
        } else {
            System.out.println("[" + level + "]" + message);
        }
    }

    public void log(MailetContext.LogLevel level, String message, Throwable t) {
        if (this.logger.isPresent()) {
            switch (level) {
                case INFO: {
                    this.logger.get().info(message, t);
                    break;
                }
                case WARN: {
                    this.logger.get().warn(message, t);
                    break;
                }
                case ERROR: {
                    this.logger.get().error(message, t);
                    break;
                }
                default: {
                    this.logger.get().debug(message, t);
                    break;
                }
            }
        } else {
            System.out.println("[" + level + "]" + message);
            t.printStackTrace(System.out);
        }
    }

    public List<String> dnsLookup(String name, MailetContext.RecordType type) throws LookupException {
        return null;
    }

    public List<SentMail> getSentMails() {
        return ImmutableList.copyOf(this.sentMails);
    }

    public void resetSentMails() {
        this.sentMails.clear();
    }

    public List<BouncedMail> getBouncedMails() {
        return ImmutableList.copyOf(this.bouncedMails);
    }

    public Logger getLogger() {
        return this.logger.orElse(null);
    }

    public static class Builder {
        private Logger logger;
        private Optional<MailAddress> postmaster = Optional.empty();

        private Builder() {
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder postmaster(MailAddress postmaster) {
            this.postmaster = Optional.of(postmaster);
            return this;
        }

        public FakeMailContext build() {
            return new FakeMailContext(Optional.ofNullable(this.logger), this.postmaster.orElse(null));
        }
    }

    public static class SentMail {
        private final MailAddress sender;
        private final Collection<MailAddress> recipients;
        private final MimeMessage msg;
        private final Optional<String> subject;
        private final Map<AttributeName, Attribute> attributes;
        private final String state;
        private final Optional<Delay> delay;

        private static MimeMessage tryCopyMimeMessage(MimeMessage msg) throws MessagingException {
            ThrowingFunction throwingFunction = MimeMessageWrapper::wrap;
            return Optional.ofNullable(msg).map(Throwing.function((ThrowingFunction)throwingFunction).sneakyThrow()).orElse(null);
        }

        private SentMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage msg, Map<AttributeName, Attribute> attributes, String state, Optional<Delay> delay) throws MessagingException {
            this.sender = sender;
            this.recipients = ImmutableList.copyOf(recipients);
            this.msg = SentMail.tryCopyMimeMessage(msg);
            this.subject = this.getSubject(msg);
            this.attributes = ImmutableMap.copyOf(attributes);
            this.state = state;
            this.delay = delay;
        }

        private Optional<String> getSubject(MimeMessage msg) {
            try {
                return Optional.ofNullable(msg.getSubject());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        public MailAddress getSender() {
            return this.sender;
        }

        public Collection<MailAddress> getRecipients() {
            return this.recipients;
        }

        public MimeMessage getMsg() {
            return this.msg;
        }

        public String getState() {
            return this.state;
        }

        public Optional<String> getSubject() {
            return this.subject;
        }

        public Map<AttributeName, Attribute> getAttributes() {
            return ImmutableMap.copyOf(this.attributes);
        }

        public Optional<Delay> getDelay() {
            return this.delay;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SentMail)) {
                return false;
            }
            SentMail sentMail = (SentMail)o;
            return Objects.equals(this.sender, sentMail.sender) && Objects.equals(this.recipients, sentMail.recipients) && Objects.equals(this.attributes, sentMail.attributes) && Objects.equals(this.state, sentMail.state);
        }

        public int hashCode() {
            return Objects.hash(this.sender, this.recipients, this.attributes, this.state);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("recipients", this.recipients).add("sender", (Object)this.sender).add("attributeNames", this.attributes).add("state", (Object)this.state).toString();
        }

        public static class Builder {
            private MailAddress sender;
            private Optional<Collection<MailAddress>> recipients = Optional.empty();
            private MimeMessage msg;
            private Map<AttributeName, Attribute> attributes = new HashMap<AttributeName, Attribute>();
            private Optional<String> state = Optional.empty();
            private Optional<Boolean> fromMailet = Optional.empty();
            private Optional<Delay> delay = Optional.empty();

            public Builder sender(MailAddress sender) {
                this.sender = sender;
                return this;
            }

            public Builder sender(Optional<MailAddress> sender) {
                sender.ifPresent(this::sender);
                return this;
            }

            public Builder sender(String sender) throws AddressException {
                return this.sender(new MailAddress(sender));
            }

            public Builder recipients(Collection<MailAddress> recipients) {
                this.recipients = Optional.of(recipients);
                return this;
            }

            public Builder fromMailet() {
                this.fromMailet = Optional.of(true);
                return this;
            }

            public Builder recipients(MailAddress ... recipients) {
                this.recipients = Optional.of(ImmutableList.copyOf((Object[])recipients));
                return this;
            }

            public Builder recipient(MailAddress recipient) {
                Preconditions.checkNotNull((Object)recipient);
                return this.recipients((Collection<MailAddress>)ImmutableList.of((Object)recipient));
            }

            public Builder recipient(String recipient) throws AddressException {
                Preconditions.checkNotNull((Object)recipient);
                return this.recipients(new MailAddress(recipient));
            }

            public Builder message(MimeMessage mimeMessage) {
                this.msg = mimeMessage;
                return this;
            }

            public Builder attributes(List<Attribute> attributes) {
                this.attributes.putAll((Map)attributes.stream().collect(ImmutableMap.toImmutableMap(attribute -> attribute.getName(), Function.identity())));
                return this;
            }

            @Deprecated
            public Builder attribute(String key, Serializable value) {
                return this.attribute(Attribute.convertToAttribute((String)key, (Object)value));
            }

            public Builder attribute(Attribute attribute) {
                this.attributes.put(attribute.getName(), attribute);
                return this;
            }

            public Builder state(String state) {
                this.state = Optional.of(state);
                return this;
            }

            public Builder delay(Delay delay) {
                this.delay = Optional.of(delay);
                return this;
            }

            public SentMail build() throws MessagingException {
                if (this.fromMailet.orElse(false).booleanValue()) {
                    this.attribute(Mail.SENT_BY_MAILET_ATTRIBUTE);
                }
                return new SentMail(this.sender, this.recipients.orElse((Collection<MailAddress>)ImmutableList.of()), this.msg, (Map<AttributeName, Attribute>)ImmutableMap.copyOf(this.attributes), this.state.orElse("root"), this.delay);
            }
        }
    }

    public static class BouncedMail {
        private final SentMail sentMail;
        private final String message;
        private final Optional<MailAddress> bouncer;

        public BouncedMail(SentMail sentMail, String message, Optional<MailAddress> bouncer) {
            this.sentMail = sentMail;
            this.message = message;
            this.bouncer = bouncer;
        }

        public BouncedMail(SentMail.Builder sentMail, String message, Optional<MailAddress> bouncer) throws MessagingException {
            this(sentMail.build(), message, bouncer);
        }

        public SentMail getSentMail() {
            return this.sentMail;
        }

        public String getMessage() {
            return this.message;
        }

        public Optional<MailAddress> getBouncer() {
            return this.bouncer;
        }

        public boolean equals(Object o) {
            if (o instanceof BouncedMail) {
                BouncedMail that = (BouncedMail)o;
                return Objects.equals(this.sentMail, that.sentMail) && Objects.equals(this.message, that.message) && Objects.equals(this.bouncer, that.bouncer);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.sentMail, this.message, this.bouncer);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sentMail", (Object)this.sentMail).add("message", (Object)this.message).add("bouncer", this.bouncer).toString();
        }
    }

    public static class Delay {
        private final long duration;
        private final TimeUnit timeUnit;

        public Delay(long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        public long getDuration() {
            return this.duration;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public final boolean equals(Object o) {
            if (o instanceof Delay) {
                Delay delay = (Delay)o;
                return Objects.equals(this.duration, delay.duration) && Objects.equals((Object)this.timeUnit, (Object)delay.timeUnit);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.duration, this.timeUnit});
        }
    }
}

