/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.util;

import java.util.Collection;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.utils.MailAddressCollectionReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailAddressCollectionReaderTest {
    MailAddressCollectionReaderTest() {
    }

    @Test
    void readShouldThrowOnNullInput() {
        Assertions.assertThatThrownBy(() -> MailAddressCollectionReader.read(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void readShouldThrowOnEmptyInput() {
        Assertions.assertThatThrownBy(() -> MailAddressCollectionReader.read((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void readShouldThrowOnInvalidEmail() {
        Assertions.assertThatThrownBy(() -> MailAddressCollectionReader.read((String)"not_valid")).isInstanceOf(RuntimeException.class);
    }

    @Test
    void readShouldThrowOnInvalidEmailOnSecondPosition() {
        Assertions.assertThatThrownBy(() -> MailAddressCollectionReader.read((String)"valid@apache.org, not_valid")).isInstanceOf(RuntimeException.class);
    }

    @Test
    void readShouldParseOneEmail() throws Exception {
        MailAddress mailAddress = new MailAddress("valid@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)mailAddress.toString())).containsExactly((Object[])new Optional[]{Optional.of(mailAddress)});
    }

    @Test
    void readShouldParseNullSender() {
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)"<>")).containsExactly((Object[])new Optional[]{Optional.empty()});
    }

    @Test
    void readShouldParseTwoEmailSeparatedByComaOnly() throws Exception {
        MailAddress mailAddress1 = new MailAddress("valid@apache.org");
        MailAddress mailAddress2 = new MailAddress("bis@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)(mailAddress1.toString() + "," + mailAddress2.toString()))).containsExactly((Object[])new Optional[]{Optional.of(mailAddress1), Optional.of(mailAddress2)});
    }

    @Test
    void readShouldParseTwoEmailSeparatedBySpaceOnly() throws Exception {
        MailAddress mailAddress1 = new MailAddress("valid@apache.org");
        MailAddress mailAddress2 = new MailAddress("bis@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)(mailAddress1.toString() + " " + mailAddress2.toString()))).containsExactly((Object[])new Optional[]{Optional.of(mailAddress1), Optional.of(mailAddress2)});
    }

    @Test
    void readShouldParseTwoEmailSeparatedByTabOnly() throws Exception {
        MailAddress mailAddress1 = new MailAddress("valid@apache.org");
        MailAddress mailAddress2 = new MailAddress("bis@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)(mailAddress1.toString() + "\t" + mailAddress2.toString()))).containsExactly((Object[])new Optional[]{Optional.of(mailAddress1), Optional.of(mailAddress2)});
    }

    @Test
    void readShouldParseTwoEmailSeparatorsCombination() throws Exception {
        MailAddress mailAddress1 = new MailAddress("valid@apache.org");
        MailAddress mailAddress2 = new MailAddress("bis@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)(mailAddress1.toString() + ",\t  \t,\t \t " + mailAddress2.toString()))).containsExactly((Object[])new Optional[]{Optional.of(mailAddress1), Optional.of(mailAddress2)});
    }

    @Test
    void readShouldRemoveDuplicates() throws Exception {
        MailAddress mailAddress = new MailAddress("valid@apache.org");
        Assertions.assertThat((Collection)MailAddressCollectionReader.read((String)(mailAddress.toString() + ", " + mailAddress.toString()))).containsExactly((Object[])new Optional[]{Optional.of(mailAddress)});
    }
}

