/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.UserIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UserIsTest {
    private UserIs matcher;

    UserIsTest() {
    }

    @BeforeEach
    void setUp() {
        this.matcher = new UserIs();
    }

    @Test
    void shouldMatchCorrespondingUser() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").condition("any").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldMatchCorrespondingUserAccrossDomains() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").condition("any").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2});
    }

    @Test
    void shouldNotMatchNonSpecifiedUsersButPreserveSpecifiedUsers() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").condition("any").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldNotMatchNonSpecifiedUsers() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").condition("any").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void initShouldThrowOnMissingCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnEmptyCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("UserIs").build())).isInstanceOf(MessagingException.class);
    }
}

