/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.TooManyRecipients;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TooManyRecipientsTest {
    private TooManyRecipients testee;

    TooManyRecipientsTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new TooManyRecipients();
    }

    @Test
    void initShouldThrowOnAbsentCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("matcherName").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnInvalidCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("a").matcherName("matcherName").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnEmptyCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("").matcherName("matcherName").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnZeroCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("0").matcherName("matcherName").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnNegativeCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("-10").matcherName("matcherName").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void matchShouldReturnNoRecipientWhenMailHaveNoRecipient() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("3").matcherName("matcherName").build());
        Collection result = this.testee.match((Mail)FakeMail.builder().name("mail").build());
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void matchShouldAcceptMailsUnderLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("3").matcherName("matcherName").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient("cuong.tran@gmail.com").build();
        Collection result = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void matchShouldAcceptMailsAtLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("3").matcherName("matcherName").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new String[]{"cuong.tran@gmail.com", "suu.tran@gmail.com", "tuan.tran@gmail.com"}).build();
        Collection result = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void matchShouldRejectMailsOverLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("3").matcherName("matcherName").build());
        ImmutableList mailAddresses = ImmutableList.of((Object)new MailAddress("cuong.tran@gmail.com"), (Object)new MailAddress("suu.tran@gmail.com"), (Object)new MailAddress("tuan.tran@gmail.com"), (Object)new MailAddress("sang.tran@gmail.com"));
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients((List)mailAddresses).build();
        Collection result = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)result).isEqualTo((Object)mailAddresses);
    }
}

