/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.matchers.TooManyLines;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TooManyLinesTest {
    private TooManyLines testee;

    TooManyLinesTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new TooManyLines();
    }

    @Test
    void initShouldThrowOnAbsentCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("name").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnInvalidCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("a").matcherName("name").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnEmptyCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("").matcherName("name").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnZeroCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("0").matcherName("name").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnNegativeCondition() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("-10").matcherName("name").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void matchShouldReturnNoRecipientWhenMailHaveNoMimeMessageAndConditionIs100() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("100").matcherName("name").build());
        Collection result = this.testee.match((Mail)FakeMail.builder().name("mail").build());
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void matchShouldAcceptMailsUnderLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("100").matcherName("name").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("content")})).build();
        Collection result = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void matchShouldRejectMailsOverLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().condition("10").matcherName("name").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11")})).build();
        Collection result = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)result).containsAll((Iterable)fakeMail.getRecipients());
    }
}

