/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SubjectStartsWith;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubjectStartsWithTest {
    private SubjectStartsWith matcher;
    private MailAddress roger;

    @BeforeEach
    public void setup() throws AddressException {
        this.matcher = new SubjectStartsWith();
        this.roger = new MailAddress("roger@nasa.org");
    }

    @Test
    public void shouldMatchWhenSubjectStartsWithConfiguredValue() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.roger}).mimeMessage(MailUtil.createMimeMessageWithSubject((String)"testSubject")).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectStartsWith").condition("test").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{this.roger});
    }

    @Test
    public void shouldNotMatchWhenSubjectDoesntStartWithConfiguredValue() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.roger}).mimeMessage(MailUtil.createMimeMessageWithSubject((String)"foobar")).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectStartsWith").condition("test").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    public void shouldNotMatchWhenNoSubject() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.roger}).mimeMessage(MailUtil.createMimeMessageWithSubject(null)).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectStartsWith").condition("test").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }
}

