/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SubjectIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubjectIsTest {
    private SubjectIs matcher;
    private MailAddress roger;

    @BeforeEach
    public void setup() throws AddressException {
        this.matcher = new SubjectIs();
        this.roger = new MailAddress("roger@nasa.org");
    }

    @Test
    public void shouldMatchWhenSubjectEqualsConfiguredValue() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessageWithSubject((String)"test")).recipients(new MailAddress[]{this.roger}).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectIs").condition("test").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{this.roger});
    }

    @Test
    public void shouldNotMatchWhenSubjectDoesntEqualsConfiguredValue() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessageWithSubject((String)"foobar")).recipients(new MailAddress[]{this.roger}).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectIs").condition("foo").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    public void shouldNotMatchWhenNoSubject() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MailUtil.createMimeMessageWithSubject(null)).recipients(new MailAddress[]{this.roger}).build();
        FakeMatcherConfig mailetConfig = FakeMatcherConfig.builder().matcherName("SubjectIs").condition("foo").build();
        this.matcher.init((MatcherConfig)mailetConfig);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }
}

