/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SizeGreaterThan;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SizeGreaterThanTest {
    private Matcher matcher;

    SizeGreaterThanTest() {
    }

    @BeforeEach
    void setUp() {
        this.matcher = new SizeGreaterThan();
    }

    @Test
    void matchShouldMatchWhenMailAboveSize() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(2000000L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("1m").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void matchShouldNotMatchWhenMailUnderSize() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(200000L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("1m").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    void matchShouldNotMatchMailsWithSpecifiedSize() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(1024L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("1k").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    void matchShouldMatchMailsWithSizeSuperiorToSpecifiedSize() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(1025L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("1k").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void matchShouldReturnNullWhenUnderLimitNoUnit() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(4L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("4").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    void matchShouldMatchOverLimitWhenNoUnit() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").size(5L).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("4").build();
        this.matcher.init((MatcherConfig)matcherConfiguration);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void initShouldThrowOnInvalidUnits() {
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("1mb").build();
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)matcherConfiguration)).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnNullSize() {
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("0").build();
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)matcherConfiguration)).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowOnNegativeSize() {
        FakeMatcherConfig matcherConfiguration = FakeMatcherConfig.builder().matcherName("SizeGreaterThan").condition("-1").build();
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)matcherConfiguration)).isInstanceOf(MessagingException.class);
    }
}

