/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SentByMailet;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SentByMailetTest {
    private SentByMailet testee;

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new SentByMailet();
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("matcherName").mailetContext((MailetContext)FakeMailContext.defaultContext()).build());
    }

    @Test
    public void matchShouldReturnRecipientsWhenAuthUserAttributeIsPresent() throws Exception {
        MailAddress recipient = MailAddressFixture.ANY_AT_JAMES;
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(recipient).attribute(Mail.SENT_BY_MAILET_ATTRIBUTE).build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    public void matchShouldReturnEmptyCollectionWhenAuthUserAttributeIsAbsent() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES}).build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).isEmpty();
    }

    @Test
    public void matchShouldReturnEmptyCollectionWhenAuthUserAttributeIsAbsentAndThereIsNoRecipient() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients().build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).isEmpty();
    }

    @Test
    public void matchShouldReturnEmptyCollectionWhenAuthUserAttributeIsPresentAndThereIsNoRecipient() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients().attribute(Mail.SENT_BY_MAILET_ATTRIBUTE).build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).isEmpty();
    }
}

