/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SenderIsTest {
    private static final String SENDER_NAME = "test@james.apache.org";
    private SenderIs matcher;
    private MailAddress recipient;

    SenderIsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.matcher = new SenderIs();
        this.recipient = new MailAddress("recipient@james.apache.org");
    }

    @Test
    void shouldMatchWhenGoodSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(SENDER_NAME).build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender(SENDER_NAME).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldMatchNotMatchWhenNullSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(SENDER_NAME).build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender(MailAddress.nullSender()).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldMatchNotMatchWhenNoSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(SENDER_NAME).build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldMatchMatchWhenNullSenderWhenConfigured() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition("<>").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender(MailAddress.nullSender()).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldMatchMatchWhenNoSenderWhenConfigured() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition("<>").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldNotMatchWhenWrongSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(SENDER_NAME).build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender("other@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldNotMatchWhenNullSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(SENDER_NAME).build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void senderIsShouldBeConfigurableWithSeveralAddresses() throws Exception {
        String mailAddress = "any@apache.org";
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").condition(mailAddress + ", test@james.apache.org").build());
        Assertions.assertThat((Collection)this.matcher.getSenders()).containsExactly((Object[])new Optional[]{Optional.of(new MailAddress(mailAddress)), Optional.of(new MailAddress(SENDER_NAME))});
    }

    @Test
    void senderIsShouldThrowWhenNoAddressesPassedByConfiguration() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void senderIsShouldThrowWhenNoConfiguration() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIs").build())).isInstanceOf(MessagingException.class);
    }
}

