/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderIsRegex;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SenderIsRegexTest {
    private static final String SENDER_NAME = "test@james.apache.org";
    private SenderIsRegex matcher;
    private MailAddress recipient;

    SenderIsRegexTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.matcher = new SenderIsRegex();
        this.recipient = new MailAddress("recipient@apache.org");
    }

    @Test
    void shouldMatchOnMatchingPattern() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition(".*@.*").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").sender(SENDER_NAME).recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldNotMatchSubParts() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition("test").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").sender(SENDER_NAME).recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldNotMatchWhenNoSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition(".*@.*").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldNotMatchWhenNullSender() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition(".*@.*").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender(MailAddress.nullSender()).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void shouldMatchNullSenderWhenConfigured() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition("<>").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender(MailAddress.nullSender()).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldNotMatchOnNonMatchingPattern() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition("^\\.").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").sender(SENDER_NAME).recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    void initShouldThrowWhenEmptyCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowWhenNoConditions() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldThrowWhenInvalidPattern() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsRegex").condition("(.").build())).isInstanceOf(MessagingException.class);
    }
}

