/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderIsNull;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SenderIsNullTest {
    private SenderIsNull matcher;

    SenderIsNullTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.matcher = new SenderIsNull();
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderIsNull").build());
    }

    @Test
    void shouldMatchWhenNoSender() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldMatchWhenNullSender() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).sender(MailAddress.nullSender()).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldNotMatchWhenSenderIsPresent() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).sender("other@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }
}

