/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderIsLocal;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SenderIsLocalTest {
    private Matcher matcher;

    @BeforeEach
    public void setUp() throws MessagingException {
        MailetContext mailContext = (MailetContext)Mockito.mock(MailetContext.class);
        Mockito.when((Object)mailContext.isLocalEmail(MailAddressFixture.ANY_AT_JAMES)).thenReturn((Object)true);
        Mockito.when((Object)mailContext.isLocalEmail(MailAddressFixture.OTHER_AT_JAMES)).thenReturn((Object)false);
        Mockito.when((Object)mailContext.isLocalEmail(MailAddressFixture.ANY_AT_JAMES2)).thenReturn((Object)false);
        this.matcher = new SenderIsLocal();
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("SenderIsLocal").mailetContext(mailContext).build();
        this.matcher.init((MatcherConfig)mci);
    }

    @Test
    public void shouldMatchWhenLocalSender() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES2});
    }

    @Test
    public void shouldNotMatchWhenSenderIsUnknown() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.OTHER_AT_JAMES).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    public void shouldNotMatchWhenHostIsNotLocal() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES2).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    public void shouldNotMatchWhenNullSender() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddress.nullSender()).recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    public void shouldNotMatchWhenNoSender() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }
}

