/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderHostIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SenderHostIsTest {
    private SenderHostIs matcher;
    private MailetContext mailContext;

    @BeforeEach
    void setUp() {
        this.mailContext = (MailetContext)Mockito.mock(MailetContext.class);
        this.matcher = new SenderHostIs();
    }

    @Test
    void shouldMatchWhenSenderHostIsKnown() throws MessagingException {
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition("james.apache.org, james3.apache.org, james2.apache.org, james4.apache.org, james5.apache.org").build();
        this.matcher.init((MatcherConfig)mci);
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES2).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES2});
    }

    @Test
    void shouldNotMatchWhenSenderHostIsUnknown() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition("james.apache.org, james3.apache.org, james4.apache.org").build());
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES2).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    void shouldNotMatchWhenEmptyList() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition("").build());
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES2).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    void shouldNotMatchWhenNullSender() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition("domain.tld").build());
        FakeMail mail = FakeMail.builder().name("mail").sender(MailAddressFixture.ANY_AT_JAMES2).recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    void shouldNotMatchWhenNoSender() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition("").build());
        FakeMail mail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES2).build();
        Collection actual = this.matcher.match((Mail)mail);
        Assertions.assertThat((Collection)actual).isNull();
    }

    @Test
    void shouldThrowWhenNullCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderHostIs").mailetContext(this.mailContext).condition(null).build())).isInstanceOf(NullPointerException.class);
    }

    @Test
    void parseDomainsListShouldParseWhenOnlyOneDomain() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org")});
    }

    @Test
    void parseDomainsListShouldParseWhenCommaSpacePattern() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org, james2.apache.org, james3.apache.org, james4.apache.org, james5.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org"), Domain.of((String)"james2.apache.org"), Domain.of((String)"james3.apache.org"), Domain.of((String)"james4.apache.org"), Domain.of((String)"james5.apache.org")});
    }

    @Test
    void parseDomainsListShouldParseWhenCommaPattern() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org,james2.apache.org,james3.apache.org,james4.apache.org,james5.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org"), Domain.of((String)"james2.apache.org"), Domain.of((String)"james3.apache.org"), Domain.of((String)"james4.apache.org"), Domain.of((String)"james5.apache.org")});
    }

    @Test
    void parseDomainsListShouldParseWhenSpacePattern() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org james2.apache.org james3.apache.org james4.apache.org james5.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org"), Domain.of((String)"james2.apache.org"), Domain.of((String)"james3.apache.org"), Domain.of((String)"james4.apache.org"), Domain.of((String)"james5.apache.org")});
    }

    @Test
    void parseDomainsListShouldParseWhenMixedPatterns() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org james2.apache.org,james3.apache.org, james4.apache.org james5.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org"), Domain.of((String)"james2.apache.org"), Domain.of((String)"james3.apache.org"), Domain.of((String)"james4.apache.org"), Domain.of((String)"james5.apache.org")});
    }

    @Test
    void parseDomainsListShouldIgnoreEmptyDomains() {
        Collection senderHosts = this.matcher.parseDomainsList("james.apache.org   james2.apache.org james3.apache.org , james4.apache.org,,,james5.apache.org");
        Assertions.assertThat((Collection)senderHosts).containsOnly((Object[])new Domain[]{Domain.of((String)"james.apache.org"), Domain.of((String)"james2.apache.org"), Domain.of((String)"james3.apache.org"), Domain.of((String)"james4.apache.org"), Domain.of((String)"james5.apache.org")});
    }
}

