/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SenderDomainIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SenderDomainIsTest {
    private static final String SENDER_NAME = "test@james.apache.org";
    private SenderDomainIs matcher;
    private MailAddress recipient;

    SenderDomainIsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.matcher = new SenderDomainIs();
        this.recipient = new MailAddress("recipient@james.apache.org");
    }

    @Test
    void shouldMatchOnMatchingSenderDomain() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderDomainIs").condition("james.apache.org, james3.apache.org, james2.apache.org, james4.apache.org, james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").sender(SENDER_NAME).recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    void shouldNotMatchWhenWrongSenderDomain() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderDomainIs").condition("james.apache.org, james3.apache.org, james2.apache.org, james4.apache.org, james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).sender("other@james7.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void shouldNotMatchWhenNoSenderDomain() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderDomainIs").condition("james.apache.org, james3.apache.org, james2.apache.org, james4.apache.org, james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void shouldNotMatchWhenNullSenderDomain() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderDomainIs").condition("james.apache.org, james3.apache.org james2.apache.org,,,,james4.apache.org, james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").sender(MailAddress.nullSender()).recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void initShouldThrowWhenEmptyCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("SenderDomainIs").build())).isInstanceOf(NullPointerException.class);
    }
}

