/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SMTPIsAuthNetwork;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SMTPIsAuthNetworkTest {
    private SMTPIsAuthNetwork testee;
    private MailAddress recipient;

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new SMTPIsAuthNetwork();
        this.recipient = new MailAddress("recipient@domain.com");
    }

    @Test
    public void matchShouldReturnEmptyWhenNoSmtpInformation() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(this.recipient).build();
        Assertions.assertThat((Collection)this.testee.match((Mail)mail)).isEmpty();
    }

    @Test
    public void matchShouldReturnAddressesWhenAuthorizedNetwork() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(this.recipient).attribute(SMTPIsAuthNetwork.makeAttribute((Boolean)true)).build();
        Assertions.assertThat((Collection)this.testee.match((Mail)mail)).containsOnly((Object[])new MailAddress[]{this.recipient});
    }

    @Test
    public void matchShouldReturnEmptyWhenNonAuthorizedNetwork() throws Exception {
        FakeMail mail = FakeMail.builder().name("mail").recipient(this.recipient).attribute(SMTPIsAuthNetwork.makeAttribute((Boolean)false)).build();
        Assertions.assertThat((Collection)this.testee.match((Mail)mail)).isEmpty();
    }
}

