/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.AbstractHasMailAttributeTest;
import org.apache.james.transport.matchers.SMTPAuthUserIs;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SMTPAuthUserIsTest
extends AbstractHasMailAttributeTest {
    @Override
    protected String getHasMailAttribute() {
        return "test@james.apache.org";
    }

    @Override
    protected GenericMatcher createMatcher() {
        return new SMTPAuthUserIs();
    }

    @Override
    protected String getMatcherName() {
        return "SMTPAuthUserIs";
    }

    @Override
    protected void init() {
        super.init();
        this.setMailAttribute(new Attribute(Mail.SMTP_AUTH_USER, AttributeValue.of((String)"test@james.apache.org")));
    }

    @Override
    @Test
    public void testAttributeIsNotMatched() throws MessagingException {
        this.setupAll();
        this.setMailAttribute(Attribute.convertToAttribute((String)"notmatched@james.apache.org", (Object)""));
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        Assertions.assertNull((Object)matchedRecipients);
    }
}

