/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.SMTPAuthSuccessful;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SMTPAuthSuccessfulTest {
    private SMTPAuthSuccessful testee;

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new SMTPAuthSuccessful();
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("matcherName").mailetContext((MailetContext)FakeMailContext.defaultContext()).build());
    }

    @Test
    public void matchShouldReturnRecipientsWhenAuthUserAttributeIsPresent() throws Exception {
        MailAddress recipient = MailAddressFixture.OTHER_AT_JAMES;
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(recipient).attribute(new Attribute(Mail.SMTP_AUTH_USER, AttributeValue.of((String)"other"))).build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    public void matchShouldNotReturnRecipientsWhenAuthUserAttributeIsAbsent() throws Exception {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.OTHER_AT_JAMES}).build();
        Collection results = this.testee.match((Mail)fakeMail);
        Assertions.assertThat((Collection)results).isEmpty();
    }
}

