/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.RelayLimit;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RelayLimitTest {
    private RelayLimit testee;
    private Mail mail;
    private MimeMessage mimeMessage;

    RelayLimitTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testee = new RelayLimit();
        this.mimeMessage = MimeMessageUtil.defaultMimeMessage();
        this.mail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).mimeMessage(this.mimeMessage).build();
    }

    @Test
    void relayLimitShouldBeANumber() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("Abc").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void relayLimitShouldBeSpecified() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void relayLimitShouldNotBeNull() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("0").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void relayLimitShouldThrowWhenConditionLessThanZero() {
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("-1").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldNotMatchWhenNoReceivedHeader() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("2").build());
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isNull();
    }

    @Test
    void shouldNotMatchWhenNotEnoughReceivedHeader() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("2").build());
        this.mimeMessage.addHeader("Received", "any");
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isNull();
    }

    @Test
    void shouldMatchWhenEqualToLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("2").build());
        this.mimeMessage.addHeader("Received", "any");
        this.mimeMessage.addHeader("Received", "any");
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldMatchWhenWhenOverLimit() throws Exception {
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RelayLimit").condition("2").build());
        this.mimeMessage.addHeader("Received", "any");
        this.mimeMessage.addHeader("Received", "any");
        this.mimeMessage.addHeader("Received", "any");
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }
}

