/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.RecipientIsRegex;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RecipientIsRegexTest {
    private RecipientIsRegex matcher;

    RecipientIsRegexTest() {
    }

    @BeforeEach
    void setUp() {
        this.matcher = new RecipientIsRegex();
    }

    @Test
    void shouldMatchOneAddress() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").condition(".*@.*").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldNotMatchPartially() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").condition("any").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void shouldMatchOnlyMatchingPatterns() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").condition("^any@.*").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldNotMatchNonMatchingPatterns() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").condition(".*\\+").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void testRegexIsNotMatchedCauseError() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").condition("(.").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void testThrowExceptionWithEmptyPattern() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void testThrowExceptionWithNoCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientIsRegex").build())).isInstanceOf(MessagingException.class);
    }
}

