/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.RecipientIsLocal;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RecipientIsLocalTest {
    public static final String MATCHER_NAME = "matcherName";
    private RecipientIsLocal testee;
    private MailetContext mailetContext;
    private MailAddress mailAddress1;
    private MailAddress mailAddress2;
    private Mail mail;

    @BeforeEach
    public void setUp() throws Exception {
        this.mailetContext = (MailetContext)Mockito.mock(MailetContext.class);
        this.testee = new RecipientIsLocal();
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName(MATCHER_NAME).mailetContext(this.mailetContext).build());
        this.mailAddress1 = new MailAddress("mail1@domain.com");
        this.mailAddress2 = new MailAddress("mail2@domain.com");
        this.mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{this.mailAddress1, this.mailAddress2}).build();
    }

    @Test
    public void matchShouldNotReturnNonExistingAddress() throws Exception {
        Mockito.when((Object)this.mailetContext.localRecipients((Collection)ArgumentMatchers.any())).thenReturn((Object)ImmutableList.of());
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isEmpty();
    }

    @Test
    public void matchShouldNotReturnNonExistingAddressIfSomeRecipientsExists() throws Exception {
        Mockito.when((Object)this.mailetContext.localRecipients((Collection)ArgumentMatchers.any())).thenReturn((Object)ImmutableList.of((Object)this.mailAddress1));
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsOnly((Object[])new MailAddress[]{this.mailAddress1});
    }

    @Test
    public void matchShouldHandleTwoValidAddress() throws Exception {
        Mockito.when((Object)this.mailetContext.localRecipients((Collection)ArgumentMatchers.any())).thenReturn((Object)ImmutableList.of((Object)this.mailAddress1, (Object)this.mailAddress2));
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsOnly((Object[])new MailAddress[]{this.mailAddress1, this.mailAddress2});
    }

    @Test
    public void matchShouldNotMatchMailWithNoRecipient() throws Exception {
        Assertions.assertThat((Collection)this.testee.match((Mail)FakeMail.defaultFakeMail())).isEmpty();
    }
}

