/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.RecipientDomainIs;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RecipientDomainIsTest {
    private RecipientDomainIs matcher;

    RecipientDomainIsTest() {
    }

    @BeforeEach
    void setUp() {
        this.matcher = new RecipientDomainIs();
    }

    @Test
    void shouldMatchOneAddress() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientDomainIs").condition("james.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldOnlyMatchCorrespondingAddress() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientDomainIs").condition("james.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    void shouldNotMatchUnrelatedAddresses() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientDomainIs").condition("james.apache.org james3.apache.org,james4.apache.org,,,james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.OTHER_AT_JAMES2, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isEmpty();
    }

    @Test
    void initShouldThrowOnMissingCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientDomainIs").build())).isInstanceOf(NullPointerException.class);
    }

    @Test
    void shouldBeAbleToMatchSeveralAddresses() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("RecipientDomainIs").condition("james.apache.org james3.apache.org james2.apache.org james4.apache.org james5.apache.org").build());
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsOnly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2, MailAddressFixture.OTHER_AT_JAMES2});
    }
}

