/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.matchers.NESSpamCheck;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NESSpamCheckTest {
    private NESSpamCheck matcher;

    @BeforeEach
    public void setUp() throws Exception {
        this.matcher = new NESSpamCheck();
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("NESSpamCheck").build();
        this.matcher.init((MatcherConfig)mci);
    }

    @Test
    public void testNESSpamCheckMatched() throws MessagingException {
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage((String)"Received", (String)"xxxxxxxxxxxxxxxxxxxxx"));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).hasSize(2);
    }

    @Test
    public void testNESSpamCheckNotMatched() throws MessagingException {
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage((String)"defaultHeaderName", (String)"defaultHeaderValue"));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }
}

