/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.HostIs;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HostIsTest {
    private Matcher matcher;

    @BeforeEach
    public void setUp() throws Exception {
        this.matcher = new HostIs();
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("HostIs").condition("james.apache.org").build();
        this.matcher.init((MatcherConfig)mci);
    }

    @Test
    public void shouldMatchWhenRightDomain() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES});
    }

    @Test
    public void shouldMatchOnlyWhenRightDomain() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    public void shouldNotMatchWhenWrongDomain() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES2, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isEmpty();
    }
}

