/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.HostIsLocal;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class HostIsLocalTest {
    private Matcher matcher;

    @BeforeEach
    public void setUp() throws Exception {
        MailetContext mailContext = (MailetContext)Mockito.mock(MailetContext.class);
        Mockito.when((Object)mailContext.isLocalServer(Domain.of((String)"james.apache.org"))).thenReturn((Object)true);
        Mockito.when((Object)mailContext.isLocalServer(Domain.of((String)"james2.apache.org"))).thenReturn((Object)false);
        this.matcher = new HostIsLocal();
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("HostIsLocal").mailetContext(mailContext).build();
        this.matcher.init((MatcherConfig)mci);
    }

    @Test
    public void shouldMatchAddressesFromLocalDomain() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES});
    }

    @Test
    public void shouldMatchOnlyAddressesFromLocalDomain() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.ANY_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES});
    }

    @Test
    public void shouldNotMatchAddressesFromDistantDomains() throws MessagingException {
        FakeMail mail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES2, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isEmpty();
    }
}

