/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.matchers.HasMimeTypeParameter;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HasMimeTypeParameterTest {
    private static final String TEST_CONTENT_TYPE = "multipart/report; report-type=\"disposition-notification\"; boundary=\"=-ac61K8KXSRpaQ/eveStc\"";
    private HasMimeTypeParameter matcher;
    private FakeMail sampleMail;

    HasMimeTypeParameterTest() {
    }

    @BeforeEach
    void setUp() throws MessagingException {
        this.matcher = new HasMimeTypeParameter();
        this.sampleMail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("Mail read").addHeader("Content-Type", TEST_CONTENT_TYPE).setText("You email has been read by Bart", TEST_CONTENT_TYPE)).sender(MailAddressFixture.SENDER).recipient(MailAddressFixture.RECIPIENT1).build();
    }

    @Test
    void shouldThrowWhenConditionHasNoEquals() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("abc").build())).isInstanceOf(MailetException.class);
    }

    @Test
    void shouldThrowWhenConditionHasNoValue() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("abc=").build())).isInstanceOf(MailetException.class);
    }

    @Test
    void shouldThrowWhenConditionHasNoName() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("=abc").build())).isInstanceOf(MailetException.class);
    }

    @Test
    void shouldSupportEqualsInValue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("abc=123,def==--").build());
        Assertions.assertThat((List)this.matcher.filteredMimeTypeParameters).contains((Object[])new Pair[]{Pair.of((Object)"def", (Object)"=--")});
    }

    @Test
    void shouldMatchNothingWhenNoCondition() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).isEmpty();
    }

    @Test
    void shouldNotMatchWhenConditionNotFulfilled() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("no-entry=for-that").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).isEmpty();
    }

    @Test
    void shouldMatchReportType() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("report-type=\"disposition-notification\"").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
    }

    @Test
    void shouldMatchAnyConfigurationCondition() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("report-type=\"not found\",boundary=\"=-ac61K8KXSRpaQ/eveStc\"").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
    }

    @Test
    void shouldMatchConditionWithSameKey() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("report-type=\"not found\",report-type=\"disposition-notification\"").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
    }

    @Test
    void shouldMatchReportTypeEvenWithoutQuotaInConfiguration() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("report-type=disposition-notification").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.sampleMail)).contains((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
    }
}

