/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.matchers.HasMimeTypeAnySubPart;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class HasMimeTypeAnySubPartTest {
    private static final String RECIPIENT = "test@james.apache.org";
    private static final String FROM = "test@james.apache.org";
    private static final String MIME_TYPES = "multipart/mixed";
    private HasMimeTypeAnySubPart matcher;

    HasMimeTypeAnySubPartTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.matcher = new HasMimeTypeAnySubPart();
    }

    @Test
    void shouldMatchWhenHasMimeTypeTopLevel() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition(MIME_TYPES).build());
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").disposition("text"), MimeMessageBuilder.bodyPartBuilder().filename("text_file.txt").disposition("attachment"), MimeMessageBuilder.bodyPartBuilder().type("application/zip").filename("zip_file.zip").disposition("attachment")}).setSubject("test");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender("test@james.apache.org").recipient("test@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    void shouldNotMatchWhenTypeDoNotAppearInParts() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("application/zip").build());
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").disposition("text"), MimeMessageBuilder.bodyPartBuilder().filename("text_file.txt").disposition("attachment"), MimeMessageBuilder.bodyPartBuilder().type("image/png").filename("file.png").disposition("attachment")}).setSubject("test");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender("test@james.apache.org").recipient("test@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isEmpty();
    }

    @Test
    void shouldMatchWhenTypeDoAppearInParts() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("text/plain, application/zip").build());
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new MimeMessageBuilder.BodyPartBuilder[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").disposition("text"), MimeMessageBuilder.bodyPartBuilder().filename("text_file.txt").disposition("attachment"), MimeMessageBuilder.bodyPartBuilder().type("application/zip").filename("zip_file.zip").disposition("attachment")}).setSubject("test");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender("test@james.apache.org").recipient("test@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    void matchShouldReturnRecipientsWhenAtLeastOneMimeTypeMatch() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("text/md, text/html").build());
        MimeMessageBuilder message = MimeMessageBuilder.mimeMessageBuilder().setText("content <b>in</b> <i>HTML</i>", "text/html").setSubject("test");
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender("test@james.apache.org").recipient("test@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactlyElementsOf((Iterable)mail.getRecipients());
    }

    @Test
    void matchShouldNotFailOnEmptyCharset() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasMimeType").condition("text/html").build());
        MimeMessage message = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)message.getHeader("Content-Type")).thenReturn((Object)new String[]{"text/html; charset="});
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(message).sender("test@james.apache.org").recipient("test@james.apache.org").build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsExactlyElementsOf((Iterable)mail.getRecipients());
    }
}

