/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.AbstractHasMailAttributeTest;
import org.apache.james.transport.matchers.HasMailAttributeWithValue;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HasMailAttributeWithValueTest
extends AbstractHasMailAttributeTest {
    @Override
    protected String getHasMailAttribute() {
        return MAIL_ATTRIBUTE.getName().asString() + ", " + MAIL_ATTRIBUTE.getValue().value();
    }

    @Override
    protected GenericMatcher createMatcher() {
        return new HasMailAttributeWithValue();
    }

    @Test
    void testAttributeIsNotMatchedCauseValue() throws MessagingException {
        this.setMailAttribute(new Attribute(MAIL_ATTRIBUTE.getName(), AttributeValue.of((String)"false")));
        this.setupMockedMail();
        this.setupMatcher();
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        Assertions.assertNull((Object)matchedRecipients);
    }

    @Override
    protected String getMatcherName() {
        return "HasMailAttributeWithValue";
    }
}

