/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.AbstractHasMailAttributeTest;
import org.apache.james.transport.matchers.HasMailAttributeWithValueRegex;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class HasMailAttributeWithValueRegexTest
extends AbstractHasMailAttributeTest {
    private String regex = ".*";

    private void setRegex(String regex) {
        this.regex = regex;
    }

    @Override
    protected String getHasMailAttribute() {
        return MAIL_ATTRIBUTE.getName().asString() + ", " + this.regex;
    }

    @Override
    protected GenericMatcher createMatcher() {
        return new HasMailAttributeWithValueRegex();
    }

    @Override
    @Test
    public void testAttributeIsMatched() throws MessagingException {
        this.init();
        this.setRegex(".*");
        this.setupAll();
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)matchedRecipients);
        Assertions.assertThat((int)this.mockedMail.getRecipients().size()).isEqualTo(matchedRecipients.size());
    }

    @Test
    public void getMatcherConfigShouldNotReturnNull() throws MessagingException {
        this.init();
        this.setRegex(".*");
        this.setupAll();
        Assertions.assertThat((Object)this.matcher.getMatcherConfig()).isNotNull();
    }

    @Test
    void testHeaderIsNotMatched() throws MessagingException {
        this.setRegex("\\d");
        this.setupAll();
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        org.junit.jupiter.api.Assertions.assertNull((Object)matchedRecipients);
    }

    @Test
    void testHeaderIsNotMatchedCauseValue() throws MessagingException {
        String invalidRegex = "(!(";
        String regexException = null;
        String exception = "Malformed pattern: " + invalidRegex;
        this.setRegex(invalidRegex);
        this.setupMockedMail();
        try {
            this.setupMatcher();
        }
        catch (MessagingException m) {
            regexException = m.getMessage();
        }
        Collection matchedRecipients = this.matcher.match((Mail)this.mockedMail);
        org.junit.jupiter.api.Assertions.assertNull((Object)matchedRecipients);
        try {
            Assertions.assertThat((String)regexException).isEqualTo(exception);
        }
        catch (AssertionFailedError e) {
            Assertions.assertThat((String)regexException).isEqualTo(exception + " (org.apache.oro.text.regex.MalformedPatternException: Unmatched parentheses.)");
        }
    }

    @Override
    protected String getMatcherName() {
        return "HasMailAttributeWithValueRegex";
    }
}

