/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Arrays;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.matchers.HasHeaderWithPrefix;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HasHeaderWithPrefixTest {
    private static final String PREFIX = "X-OPENPAAS-";
    private static final String HEADER_NAME_PREFIX_1 = "X-OPENPAAS-FEATURE-A";
    private static final String HEADER_NAME_NO_PREFIX = "X-OTHER-BUSINESS";
    private Matcher matcher;

    HasHeaderWithPrefixTest() {
    }

    @BeforeEach
    void setUp() {
        this.matcher = new HasHeaderWithPrefix();
    }

    @Test
    void matchShouldReturnAddressesWhenPrefixedHeaderName() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true")).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    void matchShouldReturnAddressesWhenPrefixedHeaderNameInSpecific() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder()).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_PREFIX_1).value("true").build(), MailAddressFixture.ANY_AT_JAMES);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(MailAddressFixture.ANY_AT_JAMES));
    }

    @Test
    void matchShouldReturnAddressesWhenExactlyPrefix() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader(PREFIX, "true")).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    void matchShouldReturnAddressesWhenExactlyPrefixInSpecific() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder()).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(PREFIX).value("true").build(), MailAddressFixture.ANY_AT_JAMES);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(MailAddressFixture.ANY_AT_JAMES));
    }

    @Test
    void matchShouldReturnEmptyWhenNoPrefixedHeader() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_NO_PREFIX, "true")).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isEmpty();
    }

    @Test
    void matchShouldReturnAddressesWhenAtLeastOneHeaderPrefixed() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_PREFIX_1, "true").addHeader(HEADER_NAME_NO_PREFIX, "true")).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    void matchShouldReturnAddressesWhenAtLeastOneHeaderPrefixedInSpecific() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasHeader").condition(PREFIX).build();
        this.matcher.init((MatcherConfig)matcherConfig);
        FakeMail mail = FakeMail.builder().name("mail").mimeMessage(MimeMessageBuilder.mimeMessageBuilder()).recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES2}).build();
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_PREFIX_1).value("true").build(), MailAddressFixture.ANY_AT_JAMES);
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_NO_PREFIX).value("true").build(), MailAddressFixture.ANY_AT_JAMES);
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_NO_PREFIX).value("true").build(), MailAddressFixture.OTHER_AT_JAMES2);
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(MailAddressFixture.ANY_AT_JAMES));
    }

    @Test
    void initShouldRejectEmptyPrefix() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("").build())).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldRejectNoCondition() {
        Assertions.assertThatThrownBy(() -> this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").build())).isInstanceOf(MessagingException.class);
    }
}

