/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.transport.matchers.HasHeader;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HasHeaderTest {
    private static final String HEADER_NAME_1 = "JUNIT";
    private static final String HEADER_NAME_2 = "defaultHeaderName";
    private static final String HEADER_VALUE_1 = "defaultHeaderValue";
    private static final String HEADER_VALUE_2 = "defaultHeaderValue2";
    private FakeMail mockedMail;
    private Matcher matcher;

    @BeforeEach
    public void setUp() throws Exception {
        MimeMessage mimeMessage = MailUtil.createMimeMessage((String)HEADER_NAME_1, (String)HEADER_VALUE_1);
        this.mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.matcher = new HasHeader();
    }

    @Test
    public void matchShouldReturnAddressesWhenRightHeaderNameWithoutValue() throws MessagingException {
        FakeMatcherConfig mci = FakeMatcherConfig.builder().matcherName("HasHeader").condition(HEADER_NAME_1).build();
        this.matcher.init((MatcherConfig)mci);
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).containsAll((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    public void matchShouldReturnNullWhenWrongHeaderNameWithoutValue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition(HEADER_NAME_2).build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).isNull();
    }

    @Test
    public void matchShouldReturnAddressesWhenGoodHeaderNameAndValue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).containsAll((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    public void matchShouldReturnNullWhenWrongValue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue2").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).isNull();
    }

    @Test
    public void matchShouldReturnNullWhenWrongHeaderNameWithValueSpecified() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("defaultHeaderName=defaultHeaderValue2").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).isNull();
    }

    @Test
    public void matchShouldIgnoreExtraEquals() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue=any").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).containsAll((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    public void matchShouldNotMatchMailsWithNoHeaderWhenValueSpecified() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage());
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    public void matchShouldSupportFoldedHeaders() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("From=aduprat <duprat@linagora.com>").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("mime/headerFolded.mime")));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    public void matchShouldSupportEncodedHeaders() throws Exception {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("To=Beno\u00eet TELLIER <tellier@linagora.com>").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageUtil.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("mime/gmail.mime")));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)mail.getRecipients());
    }

    @Test
    public void matchShouldNotMatchMailsWithNoHeaderWhenValueNotSpecified() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition(HEADER_NAME_1).build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MailUtil.createMimeMessage());
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).isNull();
    }

    @Test
    public void matchShouldReturnNullWhenOneConditionIsNotTrue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT+defaultHeaderName").build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)this.mockedMail)).isNull();
    }

    @Test
    public void matchShouldReturnAddressesWhenAllConditionsMatch() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT+defaultHeaderName").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_1, HEADER_VALUE_1).addHeader(HEADER_NAME_2, HEADER_VALUE_2).build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    public void matchShouldFindTheRightHeaderLineWhenUsedWithValue() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue2").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_1, HEADER_VALUE_1).addHeader(HEADER_NAME_1, HEADER_VALUE_2).build());
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    public void matchShouldReturnAddressesWhenAllConditionsMatchGlobalAndSpecific() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT+defaultHeaderName").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageBuilder.mimeMessageBuilder().addHeader(HEADER_NAME_1, HEADER_VALUE_1).build());
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_2).value(HEADER_VALUE_2).build(), new MailAddress("test@james.apache.org"));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(new MailAddress("test@james.apache.org")));
    }

    @Test
    public void matchShouldReturnAddressesWhenAllConditionsMatchSpecific() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT+defaultHeaderName").build());
        FakeMail mail = MailUtil.createMockMail2Recipients((MimeMessage)MimeMessageBuilder.mimeMessageBuilder().build());
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_1).value(HEADER_VALUE_1).build(), new MailAddress("test@james.apache.org"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_2).value(HEADER_VALUE_2).build(), new MailAddress("test@james.apache.org"));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(new MailAddress("test@james.apache.org")));
    }

    @Test
    public void matchShouldReturnAddressesWhenAllValueConditionsMatchGlobalAndSpecific() throws MessagingException {
        this.matcher.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasHeader").condition("JUNIT=defaultHeaderValue+defaultHeaderName").build());
        FakeMail mail = FakeMail.builder().name(MailUtil.newId()).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().build()).recipients(new MailAddress[]{new MailAddress("test@james.apache.org"), new MailAddress("test2@james.apache.org"), new MailAddress("test3@james.apache.org")}).build();
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_1).value("wrong value").build(), new MailAddress("test@james.apache.org"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_1).value(HEADER_VALUE_1).build(), new MailAddress("test2@james.apache.org"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_2).value("any value").build(), new MailAddress("test2@james.apache.org"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_1).value("wrong value").build(), new MailAddress("test3@james.apache.org"));
        mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(HEADER_NAME_2).value("any value").build(), new MailAddress("test3@james.apache.org"));
        Assertions.assertThat((Collection)this.matcher.match((Mail)mail)).containsAll(Arrays.asList(new MailAddress("test2@james.apache.org")));
    }
}

