/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.matchers.HasException;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HasExceptionTest {
    private FakeMail mockedMail;
    private Matcher testee;

    HasExceptionTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        MimeMessage mimeMessage = MailUtil.createMimeMessage();
        this.mockedMail = MailUtil.createMockMail2Recipients((MimeMessage)mimeMessage);
        this.testee = new HasException();
    }

    @Test
    void matchShouldReturnAddressesWhenSpecifiedExceptionHasOccurred() throws MessagingException {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)new AddressException())));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("javax.mail.internet.AddressException").build();
        this.testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).containsExactlyElementsOf((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    void matchShouldReturnAddressesWhenSubclassOfSpecifiedExceptionHasOccurred() throws MessagingException {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)new AddressException())));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("javax.mail.MessagingException").build();
        this.testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).containsExactlyElementsOf((Iterable)this.mockedMail.getRecipients());
    }

    @Test
    void matchShouldReturnEmptyWhenOtherExceptionHasOccurred() throws MessagingException {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)new RuntimeException())));
        this.testee.init((MatcherConfig)FakeMatcherConfig.builder().matcherName("HasException").condition("javax.mail.MessagingException").build());
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).isEmpty();
    }

    @Test
    void matchShouldReturnEmptyWhenSuperclassOfSpecifiedExceptionHasOccurred() throws MessagingException {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)((Object)new MessagingException()))));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("javax.mail.internet.AddressException").build();
        this.testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).isEmpty();
    }

    @Test
    void matchShouldReturnEmptyWhenNoExceptionHasOccurred() throws MessagingException {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("java.lang.Exception").build();
        this.testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).isEmpty();
    }

    @Test
    void matchShouldReturnEmptyWhenNonExceptionIsAttached() throws MessagingException {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.of((String)"")));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("java.lang.Exception").build();
        this.testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThat((Collection)this.testee.match((Mail)this.mockedMail)).isEmpty();
    }

    @Test
    void initShouldRaiseMessagingExceptionWhenInvalidClassName() {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("java.lang.InvalidClassName").build();
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldRaiseMessagingExceptionWhenClassNameIsNotException() {
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("java.lang.String").build();
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void initShouldRaiseMessagingExceptionWhenClassNameIsNotFullyQualified() {
        this.mockedMail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)((Object)new MessagingException()))));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasException").condition("MessagingException").build();
        Assertions.assertThatThrownBy(() -> this.testee.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
    }
}

