/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.transport.matchers.HasAttachment;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class HasAttachmentTest {
    private HasAttachment testee;
    private MimeMessage mimeMessage;
    private Mail mail;

    @BeforeEach
    public void setUp() throws Exception {
        this.testee = new HasAttachment();
        this.mimeMessage = MimeMessageUtil.defaultMimeMessage();
        this.mail = FakeMail.builder().name("mail").recipient(MailAddressFixture.ANY_AT_JAMES).mimeMessage(this.mimeMessage).build();
    }

    @Test
    public void textMailsShouldNotBeMatched() throws Exception {
        this.mimeMessage.setText("A simple text message");
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isNull();
    }

    @Test
    public void emptyMultipartShouldNotBeMatched() throws Exception {
        this.mimeMessage.setContent((Multipart)new MimeMultipart());
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isNull();
    }

    @Test
    public void inlinedOnlyMultipartShouldNotBeMatched() throws Exception {
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("inline");
        part.setFileName("bahamas.png");
        mimeMultipart.addBodyPart((BodyPart)part);
        this.mimeMessage.setContent((Multipart)mimeMultipart);
        Assertions.assertThat((Collection)this.testee.match(this.mail)).isNull();
    }

    @Test
    public void multipartWithOneAttachmentShouldBeMatched() throws Exception {
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setDisposition("inline");
        mimeMultipart.addBodyPart((BodyPart)textPart);
        MimeBodyPart attachmentPart = new MimeBodyPart();
        attachmentPart.setDisposition("attachment");
        mimeMultipart.addBodyPart((BodyPart)attachmentPart);
        this.mimeMessage.setContent((Multipart)mimeMultipart);
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsAll((Iterable)this.mail.getRecipients());
    }

    @Test
    public void attachmentMailsShouldBeMatched() throws Exception {
        MimeMessage mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)mimeMessage.getContent()).thenReturn(new Object());
        Mockito.when((Object)mimeMessage.getDisposition()).thenReturn((Object)"attachment");
        Mockito.when((Object)mimeMessage.getContentType()).thenReturn((Object)"application/json");
        this.mail.setMessage(mimeMessage);
        Assertions.assertThat((Collection)this.testee.match(this.mail)).containsAll((Iterable)this.mail.getRecipients());
    }
}

