/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.FetchedFrom;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FetchedFromTest {
    private static final String EXPECTED_HEADER_VALUE = "james-user";
    private static final String WRONG_HEADER_VALUE = "defaultHeaderValue";
    private Matcher matcher;

    @BeforeEach
    public void setUp() throws MessagingException {
        this.matcher = new FetchedFrom();
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("FetchedFrom").condition(EXPECTED_HEADER_VALUE).build();
        this.matcher.init((MatcherConfig)matcherConfig);
    }

    @Test
    public void matchShouldReturnMatchWhenFetchFromHeaderHoldsRightValue() throws MessagingException {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).mimeMessage(MailUtil.createMimeMessage((String)"X-fetched-from", (String)EXPECTED_HEADER_VALUE)).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).containsExactly((Object[])new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES});
    }

    @Test
    public void matchShouldReturnNotMatchWhenFetchFromHeaderHoldsWrongValue() throws MessagingException {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).mimeMessage(MailUtil.createMimeMessage((String)"X-fetched-from", (String)WRONG_HEADER_VALUE)).build();
        Assertions.assertThat((Collection)this.matcher.match((Mail)fakeMail)).isNull();
    }

    @Test
    public void matchShouldRemoveMatchingHeaders() throws MessagingException {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).mimeMessage(MailUtil.createMimeMessage((String)"X-fetched-from", (String)EXPECTED_HEADER_VALUE)).build();
        this.matcher.match((Mail)fakeMail);
        Assertions.assertThat((Object[])fakeMail.getMessage().getHeader("X-fetched-from")).isNull();
    }

    @Test
    public void matchShouldNotRemoveNonMatchingHeaders() throws MessagingException {
        FakeMail fakeMail = FakeMail.builder().name("mail").recipients(new MailAddress[]{MailAddressFixture.ANY_AT_JAMES, MailAddressFixture.OTHER_AT_JAMES}).mimeMessage(MailUtil.createMimeMessage((String)"X-fetched-from", (String)WRONG_HEADER_VALUE)).build();
        this.matcher.match((Mail)fakeMail);
        Assertions.assertThat((Object[])fakeMail.getMessage().getHeader("X-fetched-from")).containsExactly((Object[])new String[]{WRONG_HEADER_VALUE});
    }
}

